/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class MappedKeyPairProvider
implements KeyPairProvider {
    public static final Function MAP_TO_KEY_PAIR_PROVIDER = MappedKeyPairProvider::new;
    private final Map pairsMap;

    public MappedKeyPairProvider(KeyPair ... keyPairArray) {
        this(GenericUtils.isEmpty(keyPairArray) ? Collections.emptyList() : Arrays.asList(keyPairArray));
    }

    public MappedKeyPairProvider(Collection collection) {
        this(MappedKeyPairProvider.mapUniquePairs(collection));
    }

    public MappedKeyPairProvider(Map map) {
        this.pairsMap = ValidateUtils.checkNotNullAndNotEmpty(map, "No pairs map provided", new Object[0]);
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        return this.pairsMap.values();
    }

    @Override
    public KeyPair loadKey(SessionContext sessionContext, String string) {
        return (KeyPair)this.pairsMap.get(string);
    }

    @Override
    public Iterable getKeyTypes(SessionContext sessionContext) {
        return this.pairsMap.keySet();
    }

    public String toString() {
        return String.valueOf(this.pairsMap.keySet());
    }

    public static Map mapUniquePairs(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        TreeMap<String, KeyPair> treeMap = new TreeMap<String, KeyPair>(String.CASE_INSENSITIVE_ORDER);
        for (KeyPair keyPair : collection) {
            String string = ValidateUtils.checkNotNullAndNotEmpty(KeyUtils.getKeyType(keyPair), "Cannot determine key type");
            KeyPair keyPair2 = treeMap.put(string, keyPair);
            ValidateUtils.checkTrue(keyPair2 == null, "Multiple keys of type=%s", (Object)string);
        }
        return treeMap;
    }
}

