/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider$1;
import org.apache.sshd.common.keyprovider.KeyPairProvider$2;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KeyPairProvider
extends KeyIdentityProvider {
    public static final String SSH_RSA = "ssh-rsa";
    public static final String SSH_DSS = "ssh-dss";
    public static final String SSH_ED25519 = "ssh-ed25519";
    public static final String ECDSA_SHA2_NISTP256 = ECCurves.nistp256.getKeyType();
    public static final String ECDSA_SHA2_NISTP384 = ECCurves.nistp384.getKeyType();
    public static final String ECDSA_SHA2_NISTP521 = ECCurves.nistp521.getKeyType();
    public static final String SSH_RSA_CERT = "ssh-rsa-cert-v01@openssh.com";
    public static final String SSH_DSS_CERT = "ssh-dss-cert-v01@openssh.com";
    public static final String SSH_ED25519_CERT = "ssh-ed25519-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP256_CERT = "ecdsa-sha2-nistp256-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP384_CERT = "ecdsa-sha2-nistp384-cert-v01@openssh.com";
    public static final String SSH_ECDSA_SHA2_NISTP521_CERT = "ecdsa-sha2-nistp521-cert-v01@openssh.com";
    public static final KeyPairProvider EMPTY_KEYPAIR_PROVIDER = new KeyPairProvider$1();

    default public KeyPair loadKey(SessionContext sessionContext, String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type to load");
        return GenericUtils.stream(this.loadKeys(sessionContext)).filter(keyPair -> string.equals(KeyUtils.getKeyType(keyPair))).findFirst().orElse(null);
    }

    default public Iterable getKeyTypes(SessionContext sessionContext) {
        return GenericUtils.stream(this.loadKeys(sessionContext)).map(KeyUtils::getKeyType).filter(GenericUtils::isNotEmpty).collect(Collectors.toSet());
    }

    public static KeyPairProvider wrap(KeyPair ... keyPairArray) {
        return GenericUtils.isEmpty(keyPairArray) ? EMPTY_KEYPAIR_PROVIDER : KeyPairProvider.wrap(Arrays.asList(keyPairArray));
    }

    public static KeyPairProvider wrap(Iterable iterable) {
        return iterable == null ? EMPTY_KEYPAIR_PROVIDER : new KeyPairProvider$2(iterable);
    }
}

