/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider$1;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider$2;
import org.apache.sshd.common.keyprovider.MultiKeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;

@FunctionalInterface
public interface KeyIdentityProvider {
    public static final KeyIdentityProvider EMPTY_KEYS_PROVIDER = new KeyIdentityProvider$1();

    public Iterable loadKeys(SessionContext var1);

    public static boolean isEmpty(KeyIdentityProvider keyIdentityProvider) {
        return keyIdentityProvider == null || UnaryEquator.isSameReference(keyIdentityProvider, EMPTY_KEYS_PROVIDER);
    }

    public static KeyIdentityProvider resolveKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider, KeyIdentityProvider keyIdentityProvider2) {
        if (KeyIdentityProvider.isEmpty(keyIdentityProvider2) || UnaryEquator.isSameReference(keyIdentityProvider, keyIdentityProvider2)) {
            return keyIdentityProvider == null ? keyIdentityProvider2 : keyIdentityProvider;
        }
        if (KeyIdentityProvider.isEmpty(keyIdentityProvider)) {
            return keyIdentityProvider2;
        }
        return KeyIdentityProvider.multiProvider(keyIdentityProvider, keyIdentityProvider2);
    }

    public static KeyIdentityProvider multiProvider(KeyIdentityProvider ... keyIdentityProviderArray) {
        return KeyIdentityProvider.multiProvider(GenericUtils.asList(keyIdentityProviderArray));
    }

    public static KeyIdentityProvider multiProvider(Collection collection) {
        int n2 = GenericUtils.size(collection);
        if (n2 <= 0) {
            return EMPTY_KEYS_PROVIDER;
        }
        if (n2 == 1) {
            return (KeyIdentityProvider)GenericUtils.head(collection);
        }
        return new MultiKeyIdentityProvider(collection);
    }

    public static Iterable iterableOf(SessionContext sessionContext, Collection collection) {
        int n2 = GenericUtils.size(collection);
        if (n2 <= 0) {
            return Collections.emptyList();
        }
        if (n2 == 1) {
            KeyIdentityProvider keyIdentityProvider = (KeyIdentityProvider)GenericUtils.head(collection);
            try {
                return keyIdentityProvider.loadKeys(sessionContext);
            }
            catch (IOException | GeneralSecurityException exception) {
                throw new IllegalArgumentException("Unexpected " + exception.getClass().getSimpleName() + ") keys loading exception: " + exception.getMessage(), exception);
            }
        }
        return new KeyIdentityProvider$2(sessionContext, collection);
    }

    public static KeyIdentityProvider wrapKeyPairs(KeyPair ... keyPairArray) {
        return KeyIdentityProvider.wrapKeyPairs(GenericUtils.asList(keyPairArray));
    }

    public static KeyIdentityProvider wrapKeyPairs(Iterable iterable) {
        return iterable == null ? EMPTY_KEYS_PROVIDER : sessionContext -> iterable;
    }

    public static KeyPair exhaustCurrentIdentities(Iterator iterator) {
        while (iterator != null && iterator.hasNext()) {
            KeyPair keyPair = (KeyPair)iterator.next();
            if (keyPair == null) continue;
            return keyPair;
        }
        return null;
    }
}

