/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;

public class FileKeyPairProvider
extends AbstractResourceKeyPairProvider {
    private Collection files;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(Path path) {
        this(Collections.singletonList(Objects.requireNonNull(path, "No path provided")));
    }

    public FileKeyPairProvider(Path ... pathArray) {
        this(Arrays.asList(pathArray));
    }

    public FileKeyPairProvider(Collection collection) {
        this.files = collection;
    }

    public Collection getPaths() {
        return this.files;
    }

    public void setPaths(Collection collection) {
        List list = GenericUtils.map(collection, Path::toAbsolutePath);
        this.resetCacheMap(list);
        this.files = list;
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        return this.loadKeys(sessionContext, this.getPaths());
    }

    protected IoResource getIoResource(SessionContext sessionContext, Path path) {
        return path == null ? null : new PathResource(path);
    }

    protected Iterable doLoadKeys(SessionContext sessionContext, Path path) {
        return super.doLoadKeys(sessionContext, path == null ? null : path.toAbsolutePath());
    }
}

