/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class FileHostKeyCertificateProvider
extends AbstractLoggingBean
implements HostKeyCertificateProvider {
    private final Collection files;

    public FileHostKeyCertificateProvider(Path path) {
        this(path == null ? Collections.emptyList() : Collections.singletonList(path));
    }

    public FileHostKeyCertificateProvider(Path ... pathArray) {
        this(GenericUtils.isEmpty(pathArray) ? Collections.emptyList() : Arrays.asList(pathArray));
    }

    public FileHostKeyCertificateProvider(Collection collection) {
        this.files = ValidateUtils.checkNotNullAndNotEmpty(collection, "No paths provided", new Object[0]);
    }

    public Collection getPaths() {
        return this.files;
    }

    @Override
    public Iterable loadCertificates(SessionContext sessionContext) {
        Collection collection = this.getPaths();
        ArrayList<OpenSshCertificate> arrayList = new ArrayList<OpenSshCertificate>();
        boolean bl2 = this.log.isDebugEnabled();
        for (Path path : collection) {
            if (bl2) {
                this.log.debug("loadCertificates({}) loading file {}", (Object)sessionContext, (Object)path);
            }
            List<String> list = Files.readAllLines(path, StandardCharsets.UTF_8);
            int n2 = 0;
            for (String string : list) {
                PublicKey publicKey;
                PublicKeyEntry publicKeyEntry;
                ++n2;
                if (GenericUtils.isEmpty(string = GenericUtils.replaceWhitespaceAndTrim(string)) || string.charAt(0) == '#' || (publicKeyEntry = PublicKeyEntry.parsePublicKeyEntry(string)) == null || (publicKey = publicKeyEntry.resolvePublicKey(sessionContext, null, null)) == null) continue;
                if (!(publicKey instanceof OpenSshCertificate)) {
                    throw new InvalidKeyException("Got unexpected key type in " + path + "; line " + n2 + ". Expected OpenSSHCertificate.");
                }
                if (!OpenSshCertificate$Type.HOST.equals((Object)((OpenSshCertificate)publicKey).getType())) {
                    throw new InvalidKeyException("OpenSSHCertificate in " + path + ", line " + n2 + ", is not a host certificate.");
                }
                arrayList.add((OpenSshCertificate)publicKey);
            }
        }
        return arrayList;
    }
}

