/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.ClassLoaderResource;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class ClassLoadableResourceKeyPairProvider
extends AbstractResourceKeyPairProvider {
    private ClassLoader classLoader;
    private Collection resources;

    public ClassLoadableResourceKeyPairProvider() {
        this(Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader classLoader) {
        this(classLoader, Collections.emptyList());
    }

    public ClassLoadableResourceKeyPairProvider(String string) {
        this(Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(string, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader classLoader, String string) {
        this(classLoader, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(string, "No resource specified")));
    }

    public ClassLoadableResourceKeyPairProvider(Collection collection) {
        this.classLoader = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        this.resources = collection == null ? Collections.emptyList() : collection;
    }

    public ClassLoadableResourceKeyPairProvider(ClassLoader classLoader, Collection collection) {
        this.classLoader = classLoader;
        this.resources = collection == null ? Collections.emptyList() : collection;
    }

    public Collection getResources() {
        return this.resources;
    }

    public void setResources(Collection collection) {
        this.resources = collection == null ? Collections.emptyList() : collection;
    }

    public ClassLoader getResourceLoader() {
        return this.classLoader;
    }

    public void setResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Iterable loadKeys(SessionContext sessionContext) {
        return this.loadKeys(sessionContext, this.getResources());
    }

    protected IoResource getIoResource(SessionContext sessionContext, String string) {
        return new ClassLoaderResource(this.resolveClassLoader(), string);
    }

    protected ClassLoader resolveClassLoader() {
        ClassLoader classLoader = this.getResourceLoader();
        if (classLoader == null) {
            classLoader = ThreadUtils.resolveDefaultClassLoader(this.getClass());
        }
        return classLoader;
    }
}

