/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.AbstractResourceKeyPairProvider$KeyPairIterator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.ResourceStreamProvider;
import org.apache.sshd.common.util.security.SecurityUtils;

public abstract class AbstractResourceKeyPairProvider
extends AbstractKeyPairProvider {
    private FilePasswordProvider passwordFinder;
    private final Map cacheMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    protected AbstractResourceKeyPairProvider() {
    }

    public FilePasswordProvider getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(FilePasswordProvider filePasswordProvider) {
        this.passwordFinder = filePasswordProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCacheMap(Collection collection) {
        Set<String> set = Collections.emptySet();
        Map map = this.cacheMap;
        synchronized (map) {
            if (this.cacheMap.size() <= 0) {
                return;
            }
            if (GenericUtils.isEmpty(collection)) {
                this.cacheMap.clear();
                return;
            }
            for (Object e2 : collection) {
                String string = ValidateUtils.checkNotNullAndNotEmpty(Objects.toString(e2, null), "No resource key value");
                if (this.cacheMap.containsKey(string)) continue;
                if (set.isEmpty()) {
                    set = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                }
                if (set.add(string)) continue;
            }
            if (GenericUtils.size(set) > 0) {
                set.forEach(this.cacheMap::remove);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resetCacheMap({}) removed previous cached keys for {}", (Object)collection, set);
        }
    }

    protected Iterable loadKeys(SessionContext sessionContext, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        return () -> new AbstractResourceKeyPairProvider$KeyPairIterator(this, sessionContext, collection);
    }

    protected IoResource getIoResource(SessionContext sessionContext, Object object) {
        return IoResource.forResource(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable doLoadKeys(SessionContext sessionContext, Object object) {
        Iterable iterable;
        IoResource ioResource = (IoResource)ValidateUtils.checkNotNull((Object)this.getIoResource(sessionContext, object), "No I/O resource available for %s", object);
        String string = ValidateUtils.checkNotNullAndNotEmpty(ioResource.getName(), "No resource string value for %s", object);
        Map map = this.cacheMap;
        synchronized (map) {
            iterable = (Iterable)this.cacheMap.get(string);
        }
        if (iterable != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("doLoadKeys({}) using cached identifiers", (Object)string);
            }
            return iterable;
        }
        iterable = this.doLoadKeys(sessionContext, (NamedResource)ioResource, object, this.getPasswordFinder());
        if (iterable != null) {
            boolean bl2;
            Map map2 = this.cacheMap;
            synchronized (map2) {
                bl2 = this.cacheMap.containsKey(string);
                if (bl2) {
                    iterable = (Iterable)this.cacheMap.get(string);
                } else {
                    this.cacheMap.put(string, iterable);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("doLoadKeys({}) {}", (Object)string, (Object)(bl2 ? "re-loaded" : "loaded"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("doLoadKeys({}) no key loaded", (Object)string);
        }
        return iterable;
    }

    protected Iterable doLoadKeys(SessionContext sessionContext, NamedResource namedResource, Object object, FilePasswordProvider filePasswordProvider) {
        try (InputStream inputStream = this.openKeyPairResource(sessionContext, namedResource, object);){
            Iterable iterable = this.doLoadKeys(sessionContext, namedResource, inputStream, filePasswordProvider);
            return iterable;
        }
    }

    protected InputStream openKeyPairResource(SessionContext sessionContext, NamedResource namedResource, Object object) {
        if (namedResource instanceof ResourceStreamProvider) {
            return ((ResourceStreamProvider)((Object)namedResource)).openInputStream();
        }
        throw new StreamCorruptedException("Cannot open resource data for " + object);
    }

    protected Iterable doLoadKeys(SessionContext sessionContext, NamedResource namedResource, InputStream inputStream, FilePasswordProvider filePasswordProvider) {
        return SecurityUtils.loadKeyPairIdentities(sessionContext, namedResource, inputStream, filePasswordProvider);
    }

    static /* synthetic */ void access$000(AbstractResourceKeyPairProvider abstractResourceKeyPairProvider, String string, Object object, Object object2, Object object3, Throwable throwable) {
        abstractResourceKeyPairProvider.warn(string, object, object2, object3, throwable);
    }
}

