/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension.parser;

import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.apache.sshd.common.util.buffer.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostBoundPubkeyAuthentication
extends AbstractKexExtensionParser {
    public static final String NAME = "publickey-hostbound@openssh.com";
    public static final String AUTH_NAME = "publickey-hostbound-v00@openssh.com";
    public static final HostBoundPubkeyAuthentication INSTANCE = new HostBoundPubkeyAuthentication();
    private static final Logger LOG = LoggerFactory.getLogger(HostBoundPubkeyAuthentication.class);

    public HostBoundPubkeyAuthentication() {
        super(NAME);
    }

    @Override
    public Integer parseExtension(Buffer buffer) {
        return this.parseExtension(buffer.array(), buffer.rpos(), buffer.available());
    }

    @Override
    public Integer parseExtension(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Inconsistent KEX extension {} received; no data (len={})", (Object)NAME, (Object)n3);
            }
            return null;
        }
        String string = new String(byArray, n2, n3, StandardCharsets.UTF_8);
        try {
            Integer n4 = Integer.parseUnsignedInt(string);
            LOG.info("Server announced support for {} version {}", (Object)NAME, (Object)n4);
            return n4;
        }
        catch (NumberFormatException numberFormatException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot parse KEX extension {} version {}", (Object)NAME, (Object)string);
            }
            return null;
        }
    }

    protected void encode(Integer n2, Buffer buffer) {
        buffer.putString(n2.toString());
    }
}

