/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension.parser;

import org.apache.sshd.common.kex.extension.parser.AbstractKexExtensionParser;
import org.apache.sshd.common.kex.extension.parser.DelayedCompressionAlgorithms;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class DelayCompression
extends AbstractKexExtensionParser {
    public static final String NAME = "delay-compression";
    public static final DelayCompression INSTANCE = new DelayCompression();

    public DelayCompression() {
        super(NAME);
    }

    @Override
    public DelayedCompressionAlgorithms parseExtension(Buffer buffer) {
        DelayedCompressionAlgorithms delayedCompressionAlgorithms = new DelayedCompressionAlgorithms();
        delayedCompressionAlgorithms.setClient2Server(buffer.getNameList());
        delayedCompressionAlgorithms.setServer2Client(buffer.getNameList());
        return delayedCompressionAlgorithms;
    }

    protected void encode(DelayedCompressionAlgorithms delayedCompressionAlgorithms, Buffer buffer) {
        int n2 = buffer.wpos();
        buffer.putUInt(0L);
        buffer.putNameList(delayedCompressionAlgorithms.getClient2Server());
        buffer.putNameList(delayedCompressionAlgorithms.getServer2Client());
        BufferUtils.updateLengthPlaceholder(buffer, n2);
    }
}

