/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.kex.extension.KexExtensionParser;
import org.apache.sshd.common.kex.extension.parser.DelayCompression;
import org.apache.sshd.common.kex.extension.parser.Elevation;
import org.apache.sshd.common.kex.extension.parser.NoFlowControl;
import org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public final class KexExtensions {
    public static final byte SSH_MSG_EXT_INFO = 7;
    public static final byte SSH_MSG_NEWCOMPRESS = 8;
    public static final String CLIENT_KEX_EXTENSION = "ext-info-c";
    public static final String SERVER_KEX_EXTENSION = "ext-info-s";
    public static final Predicate IS_KEX_EXTENSION_SIGNAL = string -> CLIENT_KEX_EXTENSION.equalsIgnoreCase((String)string) || SERVER_KEX_EXTENSION.equalsIgnoreCase((String)string);
    public static final String STRICT_KEX_CLIENT_EXTENSION = "kex-strict-c-v00@openssh.com";
    public static final String STRICT_KEX_SERVER_EXTENSION = "kex-strict-s-v00@openssh.com";
    private static final NavigableMap EXTENSION_PARSERS = Stream.of(ServerSignatureAlgorithms.INSTANCE, NoFlowControl.INSTANCE, Elevation.INSTANCE, DelayCompression.INSTANCE).collect(Collectors.toMap(NamedResource::getName, Function.identity(), MapEntryUtils.throwingMerger(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));

    private KexExtensions() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensionParserNames() {
        NavigableMap navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return EXTENSION_PARSERS.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, EXTENSION_PARSERS.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser getRegisteredExtensionParser(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No extension name provided");
        NavigableMap navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return (KexExtensionParser)EXTENSION_PARSERS.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser registerExtensionParser(KexExtensionParser kexExtensionParser) {
        Objects.requireNonNull(kexExtensionParser, "No parser provided");
        String string = ValidateUtils.checkNotNullAndNotEmpty(kexExtensionParser.getName(), "No extension name provided");
        NavigableMap navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return EXTENSION_PARSERS.put(string, kexExtensionParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser unregisterExtensionParser(String string) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No extension name provided");
        NavigableMap navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return (KexExtensionParser)EXTENSION_PARSERS.remove(string);
        }
    }

    public static List parseExtensions(Buffer buffer) {
        int n2 = buffer.getInt();
        ValidateUtils.checkTrue(n2 >= 0, "Invalid extensions count: %d", n2);
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<AbstractMap.SimpleImmutableEntry<String, byte[]>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, byte[]>>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = buffer.getString();
            byte[] byArray = buffer.getBytes();
            KexExtensionParser kexExtensionParser = KexExtensions.getRegisteredExtensionParser(string);
            byte[] byArray2 = kexExtensionParser == null ? byArray : (byte[])kexExtensionParser.parseExtension(byArray);
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>(string, byArray2));
        }
        return arrayList;
    }

    public static void putExtensions(Collection collection, Buffer buffer) {
        int n2 = GenericUtils.size(collection);
        buffer.putUInt(n2);
        if (n2 <= 0) {
            return;
        }
        for (Map.Entry entry : collection) {
            String string = (String)entry.getKey();
            Object v2 = entry.getValue();
            KexExtensionParser kexExtensionParser = KexExtensions.getRegisteredExtensionParser(string);
            if (kexExtensionParser != null) {
                kexExtensionParser.putExtension(v2, buffer);
                continue;
            }
            buffer.putOptionalBufferedData(v2);
        }
    }
}

