/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$KexPhase;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultServerKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final DefaultServerKexExtensionHandler INSTANCE = new DefaultServerKexExtensionHandler();
    public static final AttributeRepository$AttributeKey CLIENT_REQUESTED_EXT_INFO = new AttributeRepository$AttributeKey();
    public static final AttributeRepository$AttributeKey EXT_INFO_SENT_AT_NEWKEYS = new AttributeRepository$AttributeKey();

    @Override
    public void handleKexInitProposal(Session session, boolean bl2, Map map) {
        if (!bl2 && session.getAttribute(CLIENT_REQUESTED_EXT_INFO) == null) {
            String string = (String)map.get((Object)KexProposalOption.ALGORITHMS);
            boolean bl3 = Arrays.asList(GenericUtils.split(string, ',')).contains("ext-info-c");
            session.setAttribute(CLIENT_REQUESTED_EXT_INFO, bl3);
            if (bl3 && this.log.isTraceEnabled()) {
                this.log.trace("handleKexInitProposal({}): got ext-info-c from client", (Object)session);
            }
        }
    }

    @Override
    public void sendKexExtensions(Session session, KexExtensionHandler$KexPhase kexExtensionHandler$KexPhase) {
        Boolean bl2;
        if (kexExtensionHandler$KexPhase == KexExtensionHandler$KexPhase.NEWKEYS) {
            bl2 = (Boolean)session.getAttribute(EXT_INFO_SENT_AT_NEWKEYS);
            if (bl2 != null && bl2.booleanValue()) {
                return;
            }
            session.setAttribute(EXT_INFO_SENT_AT_NEWKEYS, Boolean.TRUE);
        }
        if ((bl2 = (Boolean)session.getAttribute(CLIENT_REQUESTED_EXT_INFO)) == null || !bl2.booleanValue()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("sendKexExtensions({})[{}]: client did not send ext-info-c; skipping sending SSH_MSG_EXT_INFO", (Object)session, (Object)kexExtensionHandler$KexPhase);
            }
            return;
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.collectExtensions(session, kexExtensionHandler$KexPhase, linkedHashMap::put);
        if (!linkedHashMap.isEmpty()) {
            Buffer buffer = session.createBuffer((byte)7);
            KexExtensions.putExtensions(linkedHashMap.entrySet(), buffer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendKexExtensions({})[{}]: sending SSH_MSG_EXT_INFO with {} info records", new Object[]{session, kexExtensionHandler$KexPhase, linkedHashMap.size()});
            }
            session.writePacket(buffer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("sendKexExtensions({})[{}]: no extension info; skipping sending SSH_MSG_EXT_INFO", (Object)session, (Object)kexExtensionHandler$KexPhase);
        }
    }

    public void collectExtensions(Session session, KexExtensionHandler$KexPhase kexExtensionHandler$KexPhase, BiConsumer biConsumer) {
        if (kexExtensionHandler$KexPhase == KexExtensionHandler$KexPhase.NEWKEYS) {
            List list = session.getSignatureFactoriesNames();
            if (!GenericUtils.isEmpty(list)) {
                biConsumer.accept("server-sig-algs", list);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("collectExtensions({})[{}]: extension info {}: {}", new Object[]{session, kexExtensionHandler$KexPhase, "server-sig-algs", String.join((CharSequence)",", list)});
                }
            } else if (this.log.isWarnEnabled()) {
                this.log.warn("collectExtensions({})[{}]: extension info {} has no algorithms; skipping", new Object[]{session, kexExtensionHandler$KexPhase, "server-sig-algs"});
            }
        }
    }
}

