/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensionHandler$AvailabilityPhase;
import org.apache.sshd.common.kex.extension.parser.HostBoundPubkeyAuthentication;
import org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultClientKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final DefaultClientKexExtensionHandler INSTANCE = new DefaultClientKexExtensionHandler();
    public static final AttributeRepository$AttributeKey SERVER_ALGORITHMS = new AttributeRepository$AttributeKey();
    public static final AttributeRepository$AttributeKey HOSTBOUND_AUTHENTICATION = new AttributeRepository$AttributeKey();

    @Override
    public boolean isKexExtensionsAvailable(Session session, KexExtensionHandler$AvailabilityPhase kexExtensionHandler$AvailabilityPhase) {
        return !KexExtensionHandler$AvailabilityPhase.PREKEX.equals((Object)kexExtensionHandler$AvailabilityPhase);
    }

    @Override
    public boolean handleKexExtensionRequest(Session session, int n2, int n3, String string, byte[] byArray) {
        if ("server-sig-algs".equals(string)) {
            this.handleServerSignatureAlgorithms(session, (Collection)ServerSignatureAlgorithms.INSTANCE.parseExtension(byArray));
        } else if ("publickey-hostbound@openssh.com".equals(string)) {
            Integer n4 = (Integer)HostBoundPubkeyAuthentication.INSTANCE.parseExtension(byArray);
            if (n4 == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleKexExtensionRequest({}) : ignoring unknown {} extension", (Object)session, (Object)"publickey-hostbound@openssh.com");
                }
            } else if (n4 != 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleKexExtensionRequest({}) : ignoring unknown {} version {}", new Object[]{session, "publickey-hostbound@openssh.com", n4});
                }
            } else {
                session.setAttribute(HOSTBOUND_AUTHENTICATION, n4);
            }
        }
        return true;
    }

    protected void handleServerSignatureAlgorithms(Session session, Collection collection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServerSignatureAlgorithms({}): {}", (Object)session, (Object)collection);
        }
        if (collection != null && !collection.isEmpty()) {
            ArrayList arrayList = new ArrayList(session.getSignatureFactories());
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms before: {}", (Object)session, arrayList);
            }
            ArrayList<NamedFactory> arrayList2 = new ArrayList<NamedFactory>();
            TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            treeSet.addAll(collection);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                NamedFactory namedFactory = (NamedFactory)iterator.next();
                if (treeSet.contains(namedFactory.getName())) continue;
                arrayList2.add(namedFactory);
                iterator.remove();
            }
            arrayList.addAll(arrayList2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms after: {}", (Object)session, arrayList);
            }
            session.setAttribute(SERVER_ALGORITHMS, treeSet);
            session.setSignatureFactories(arrayList);
        }
    }
}

