/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex.dh;

import java.math.BigInteger;
import java.util.Objects;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractDHKeyExchange
extends AbstractLoggingBean
implements KeyExchange {
    protected byte[] v_s;
    protected byte[] v_c;
    protected byte[] i_s;
    protected byte[] i_c;
    protected Digest hash;
    protected byte[] k;
    protected byte[] h;
    private byte[] e;
    private BigInteger eValue;
    private byte[] f;
    private BigInteger fValue;
    private final Session session;

    protected AbstractDHKeyExchange(Session session) {
        this.session = Objects.requireNonNull(session, "No session provided");
    }

    @Override
    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.v_s = ValidateUtils.checkNotNullAndNotEmpty(byArray, "No v_s value");
        this.v_c = ValidateUtils.checkNotNullAndNotEmpty(byArray2, "No v_c value");
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(byArray3, "No i_s value");
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(byArray4, "No i_c value");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.h;
    }

    @Override
    public byte[] getK() {
        return this.k;
    }

    protected byte[] getE() {
        return this.e;
    }

    protected BigInteger getEValue() {
        if (this.eValue == null) {
            this.eValue = BufferUtils.fromMPIntBytes(this.getE());
        }
        return this.eValue;
    }

    protected byte[] updateE(Buffer buffer) {
        return this.updateE(buffer.getMPIntAsBytes());
    }

    protected byte[] updateE(byte[] byArray) {
        this.setE(byArray);
        return byArray;
    }

    protected void setE(byte[] byArray) {
        this.e = byArray;
        if (this.eValue != null) {
            this.eValue = null;
        }
    }

    protected void validateEValue(BigInteger bigInteger) {
        BigInteger bigInteger2 = Objects.requireNonNull(this.getEValue(), "No DH 'e' value set");
        if (!KeyExchange.isValidDHValue(bigInteger2, bigInteger)) {
            throw new SshException(3, "Protocol error: invalid DH 'e' value");
        }
    }

    protected byte[] getF() {
        return this.f;
    }

    protected BigInteger getFValue() {
        if (this.fValue == null) {
            this.fValue = BufferUtils.fromMPIntBytes(this.getF());
        }
        return this.fValue;
    }

    protected byte[] updateF(Buffer buffer) {
        return this.updateF(buffer.getMPIntAsBytes());
    }

    protected byte[] updateF(byte[] byArray) {
        this.setF(byArray);
        return byArray;
    }

    protected void setF(byte[] byArray) {
        this.f = byArray;
        if (this.fValue != null) {
            this.fValue = null;
        }
    }

    protected void validateFValue(BigInteger bigInteger) {
        BigInteger bigInteger2 = Objects.requireNonNull(this.getFValue(), "No DH 'f' value set");
        if (!KeyExchange.isValidDHValue(bigInteger2, bigInteger)) {
            throw new SshException(3, "Protocol error: invalid DH 'f' value");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

