/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.KeyPair;
import java.util.Objects;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.kex.MontgomeryCurve;
import org.apache.sshd.common.util.buffer.Buffer;

public class XDH
extends AbstractDH {
    protected MontgomeryCurve curve;
    protected byte[] f;

    public XDH(MontgomeryCurve montgomeryCurve) {
        this.curve = Objects.requireNonNull(montgomeryCurve, "No MontgomeryCurve provided");
        this.myKeyAgree = montgomeryCurve.createKeyAgreement();
    }

    @Override
    protected byte[] calculateE() {
        KeyPair keyPair = this.curve.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        return this.curve.encode(keyPair.getPublic());
    }

    @Override
    public void setF(byte[] byArray) {
        this.f = Objects.requireNonNull(byArray, "No 'f' value provided");
    }

    @Override
    public void putE(Buffer buffer, byte[] byArray) {
        buffer.putBytes(byArray);
    }

    @Override
    public void putF(Buffer buffer, byte[] byArray) {
        buffer.putBytes(byArray);
    }

    @Override
    protected byte[] calculateK() {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        this.myKeyAgree.doPhase(this.curve.decode(this.f), true);
        return XDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    @Override
    public Digest getHash() {
        return this.curve.createDigest();
    }
}

