/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum MontgomeryCurve implements OptionalFeature,
KeySizeIndicator
{
    x25519("X25519", 32, (DigestFactory)BuiltinDigests.sha256, new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 110, 3, 33, 0}),
    x448("X448", 56, (DigestFactory)BuiltinDigests.sha512, new byte[]{48, 66, 48, 5, 6, 3, 43, 101, 111, 3, 57, 0});

    private final String algorithm;
    private final int keySize;
    private final boolean supported;
    private final DigestFactory digestFactory;
    private final KeyPairGenerator keyPairGenerator;
    private final KeyFactory keyFactory;
    private final byte[] encodedPublicKeyPrefix;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private MontgomeryCurve(DigestFactory digestFactory, byte[] byArray) {
        boolean bl2;
        void var6_4;
        void var5_3;
        this.algorithm = digestFactory;
        this.keySize = (int)byArray;
        this.digestFactory = var5_3;
        this.encodedPublicKeyPrefix = var6_4;
        KeyPairGenerator keyPairGenerator = null;
        KeyFactory keyFactory = null;
        try {
            SecurityUtils.getKeyAgreement((String)((Object)digestFactory));
            keyPairGenerator = SecurityUtils.getKeyPairGenerator((String)((Object)digestFactory));
            keyFactory = SecurityUtils.getKeyFactory((String)((Object)digestFactory));
            bl2 = true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl2 = false;
        }
        this.supported = bl2 && var5_3.isSupported();
        this.keyPairGenerator = keyPairGenerator;
        this.keyFactory = keyFactory;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    public KeyAgreement createKeyAgreement() {
        return SecurityUtils.getKeyAgreement(this.algorithm);
    }

    public Digest createDigest() {
        return (Digest)this.digestFactory.create();
    }

    public KeyPair generateKeyPair() {
        return this.keyPairGenerator.generateKeyPair();
    }

    public byte[] encode(PublicKey publicKey) {
        byte[] byArray = publicKey.getEncoded();
        byte[] byArray2 = Arrays.copyOfRange(byArray, byArray.length - this.getKeySize(), byArray.length);
        return byArray2;
    }

    public PublicKey decode(byte[] byArray) {
        int n2 = this.getKeySize();
        int n3 = byArray.length - n2;
        if (n3 < 0 || n3 > 1) {
            throw new InvalidKeySpecException("Provided key has wrong length (" + byArray.length + " bytes) for " + this.getAlgorithm());
        }
        if (n3 == 1 && byArray[0] != 0) {
            throw new InvalidKeySpecException("Provided key for " + this.getAlgorithm() + " has extra byte, but it's non-zero: 0x" + Integer.toHexString(byArray[0] & 0xFF));
        }
        byte[] byArray2 = Arrays.copyOf(this.encodedPublicKeyPrefix, this.encodedPublicKeyPrefix.length + n2);
        System.arraycopy(byArray, n3, byArray2, this.encodedPublicKeyPrefix.length, n2);
        return this.keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
    }
}

