/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.util.Collections;
import java.util.NavigableMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.LoggingUtils;

public interface KeyExchange
extends NamedResource,
SessionHolder {
    public static final NavigableMap GROUP_KEX_OPCODES_MAP = Collections.unmodifiableNavigableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEX_DH_GEX_"));
    public static final NavigableMap SIMPLE_KEX_OPCODES_MAP = Collections.unmodifiableNavigableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEXDH_"));

    public void init(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public boolean next(int var1, Buffer var2);

    public Digest getHash();

    public byte[] getH();

    public byte[] getK();

    public static String getGroupKexOpcodeName(int n2) {
        String string = (String)GROUP_KEX_OPCODES_MAP.get(n2);
        if (GenericUtils.isEmpty(string)) {
            return SshConstants.getCommandMessageName(n2);
        }
        return string;
    }

    public static String getSimpleKexOpcodeName(int n2) {
        String string = (String)SIMPLE_KEX_OPCODES_MAP.get(n2);
        if (GenericUtils.isEmpty(string)) {
            return SshConstants.getCommandMessageName(n2);
        }
        return string;
    }

    public static boolean isValidDHValue(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null || bigInteger2 == null) {
            return false;
        }
        if (bigInteger.compareTo(BigInteger.ONE) <= 0) {
            return false;
        }
        return bigInteger.compareTo(bigInteger2.subtract(BigInteger.ONE)) < 0;
    }
}

