/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.util.GenericUtils;

public enum KexProposalOption {
    ALGORITHMS(0, "kex algorithms"),
    SERVERKEYS(1, "server host key algorithms"),
    C2SENC(2, "encryption algorithms (client to server)"),
    S2CENC(3, "encryption algorithms (server to client)"),
    C2SMAC(4, "mac algorithms (client to server)"),
    S2CMAC(5, "mac algorithms (server to client)"),
    C2SCOMP(6, "compression algorithms (client to server)"),
    S2CCOMP(7, "compression algorithms (server to client)"),
    C2SLANG(8, "languages (client to server)"),
    S2CLANG(9, "languages (server to client)");

    public static final Set CIPHER_PROPOSALS;
    public static final Set MAC_PROPOSALS;
    public static final Set COMPRESSION_PROPOSALS;
    public static final Set LANGUAGE_PROPOSALS;
    public static final Set FIRST_KEX_PACKET_GUESS_MATCHES;
    public static final Comparator BY_PROPOSAL_INDEX;
    public static final List VALUES;
    public static final int PROPOSAL_MAX;
    private final int proposalIndex;
    private final String description;

    /*
     * WARNING - void declaration
     */
    private KexProposalOption() {
        void var4_1;
        void var3_2;
        this.proposalIndex = var3_2;
        this.description = var4_1;
    }

    public final int getProposalIndex() {
        return this.proposalIndex;
    }

    public final String getDescription() {
        return this.description;
    }

    public static KexProposalOption fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (KexProposalOption kexProposalOption : VALUES) {
            if (!string.equalsIgnoreCase(kexProposalOption.name())) continue;
            return kexProposalOption;
        }
        return null;
    }

    public static KexProposalOption fromProposalIndex(int n2) {
        if (n2 < 0 || n2 >= VALUES.size()) {
            return null;
        }
        return (KexProposalOption)((Object)VALUES.get(n2));
    }

    static {
        CIPHER_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SENC, S2CENC));
        MAC_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SMAC, S2CMAC));
        COMPRESSION_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SCOMP, S2CCOMP));
        LANGUAGE_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SLANG, S2CLANG));
        FIRST_KEX_PACKET_GUESS_MATCHES = Collections.unmodifiableSet(EnumSet.of(ALGORITHMS, SERVERKEYS));
        BY_PROPOSAL_INDEX = Comparator.comparingInt(KexProposalOption::getProposalIndex);
        VALUES = Collections.unmodifiableList(EnumSet.allOf(KexProposalOption.class).stream().sorted(BY_PROPOSAL_INDEX).collect(Collectors.toList()));
        PROPOSAL_MAX = VALUES.size();
    }
}

