/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.BuiltinCiphers$ParseResult;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.BuiltinCompressions$ParseResult;
import org.apache.sshd.common.kex.extension.KexExtensionHandlerManager;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.BuiltinMacs$ParseResult;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface KexFactoryManager
extends KexExtensionHandlerManager,
SignatureFactoriesManager {
    public List getKeyExchangeFactories();

    public void setKeyExchangeFactories(List var1);

    public List getCipherFactories();

    default public String getCipherFactoriesNameList() {
        return NamedResource.getNames(this.getCipherFactories());
    }

    default public List getCipherFactoriesNames() {
        return NamedResource.getNameList(this.getCipherFactories());
    }

    public void setCipherFactories(List var1);

    default public void setCipherFactoriesNameList(String string) {
        this.setCipherFactoriesNames(GenericUtils.split(string, ','));
    }

    default public void setCipherFactoriesNames(String ... stringArray) {
        this.setCipherFactoriesNames(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    default public void setCipherFactoriesNames(Collection collection) {
        BuiltinCiphers$ParseResult builtinCiphers$ParseResult = BuiltinCiphers.parseCiphersList(collection);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(builtinCiphers$ParseResult.getParsedFactories(), "No supported cipher factories: %s", collection);
        List list2 = builtinCiphers$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(list2), "Unsupported cipher factories found: %s", (Object)list2);
        this.setCipherFactories(list);
    }

    public List getCompressionFactories();

    default public String getCompressionFactoriesNameList() {
        return NamedResource.getNames(this.getCompressionFactories());
    }

    default public List getCompressionFactoriesNames() {
        return NamedResource.getNameList(this.getCompressionFactories());
    }

    public void setCompressionFactories(List var1);

    default public void setCompressionFactoriesNameList(String string) {
        this.setCompressionFactoriesNames(GenericUtils.split(string, ','));
    }

    default public void setCompressionFactoriesNames(String ... stringArray) {
        this.setCompressionFactoriesNames(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    default public void setCompressionFactoriesNames(Collection collection) {
        BuiltinCompressions$ParseResult builtinCompressions$ParseResult = BuiltinCompressions.parseCompressionsList(collection);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(builtinCompressions$ParseResult.getParsedFactories(), "No supported compression factories: %s", collection);
        List list2 = builtinCompressions$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(list2), "Unsupported compression factories found: %s", (Object)list2);
        this.setCompressionFactories(list);
    }

    public List getMacFactories();

    default public String getMacFactoriesNameList() {
        return NamedResource.getNames(this.getMacFactories());
    }

    default public List getMacFactoriesNames() {
        return NamedResource.getNameList(this.getMacFactories());
    }

    public void setMacFactories(List var1);

    default public void setMacFactoriesNameList(String string) {
        this.setMacFactoriesNames(GenericUtils.split(string, ','));
    }

    default public void setMacFactoriesNames(String ... stringArray) {
        this.setMacFactoriesNames(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    default public void setMacFactoriesNames(Collection collection) {
        BuiltinMacs$ParseResult builtinMacs$ParseResult = BuiltinMacs.parseMacsList(collection);
        List list = (List)ValidateUtils.checkNotNullAndNotEmpty(builtinMacs$ParseResult.getParsedFactories(), "No supported MAC factories: %s", collection);
        List list2 = builtinMacs$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(list2), "Unsupported MAC factories found: %s", (Object)list2);
        this.setMacFactories(list);
    }
}

