/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Objects;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.security.SecurityUtils;

public class ECDH
extends AbstractDH {
    public static final String KEX_TYPE = "ECDH";
    private ECCurves curve;
    private ECParameterSpec params;
    private ECPoint f;

    public ECDH() {
        this((ECParameterSpec)null);
    }

    public ECDH(String string) {
        this((ECCurves)ValidateUtils.checkNotNull((Object)ECCurves.fromCurveName(string), "Unknown curve name: %s", (Object)string));
    }

    public ECDH(ECCurves eCCurves) {
        this(Objects.requireNonNull(eCCurves, "No known curve instance provided").getParameters());
        this.curve = eCCurves;
    }

    public ECDH(ECParameterSpec eCParameterSpec) {
        this.myKeyAgree = SecurityUtils.getKeyAgreement(KEX_TYPE);
        this.params = eCParameterSpec;
    }

    @Override
    protected byte[] calculateE() {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        KeyPairGenerator keyPairGenerator = SecurityUtils.getKeyPairGenerator("EC");
        keyPairGenerator.initialize(this.params);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        ECPublicKey eCPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPoint eCPoint = eCPublicKey.getW();
        return ECCurves.encodeECPoint(eCPoint, this.params);
    }

    @Override
    protected byte[] calculateK() {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        Objects.requireNonNull(this.f, "Missing 'f' value");
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(this.f, this.params);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("EC");
        PublicKey publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        this.myKeyAgree.doPhase(publicKey, true);
        return ECDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setCurveParameters(ECParameterSpec eCParameterSpec) {
        this.params = eCParameterSpec;
    }

    @Override
    public void setF(byte[] byArray) {
        Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
        Objects.requireNonNull(byArray, "No 'f' value specified");
        this.f = ECCurves.octetStringToEcPoint(byArray);
    }

    @Override
    public void putE(Buffer buffer, byte[] byArray) {
        buffer.putBytes(byArray);
    }

    @Override
    public void putF(Buffer buffer, byte[] byArray) {
        buffer.putBytes(byArray);
    }

    @Override
    public Digest getHash() {
        if (this.curve == null) {
            Objects.requireNonNull(this.params, "No ECParameterSpec(s)");
            this.curve = Objects.requireNonNull(ECCurves.fromCurveParameters(this.params), "Unknown curve parameters");
        }
        return this.curve.getDigestForParams();
    }

    @Override
    public String toString() {
        return super.toString() + "[curve=" + this.curve + ", f=" + this.f + "]";
    }
}

