/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public final class DHGroupData {
    private static final ConcurrentHashMap OAKLEY_GROUPS = new ConcurrentHashMap();

    private DHGroupData() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static byte[] getG() {
        return new byte[]{2};
    }

    public static byte[] getP1() {
        return new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    public static byte[] getP14() {
        return new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -28, 91, 61, -62, 0, 124, -72, -95, 99, -65, 5, -104, -38, 72, 54, 28, 85, -45, -102, 105, 22, 63, -88, -3, 36, -49, 95, -125, 101, 93, 35, -36, -93, -83, -106, 28, 98, -13, 86, 32, -123, 82, -69, -98, -43, 41, 7, 112, -106, -106, 109, 103, 12, 53, 78, 74, -68, -104, 4, -15, 116, 108, 8, -54, 24, 33, 124, 50, -112, 94, 70, 46, 54, -50, 59, -29, -98, 119, 44, 24, 14, -122, 3, -101, 39, -125, -94, -20, 7, -94, -113, -75, -59, 93, -16, 111, 76, 82, -55, -34, 43, -53, -10, -107, 88, 23, 24, 57, -107, 73, 124, -22, -107, 106, -27, 21, -46, 38, 24, -104, -6, 5, 16, 21, 114, -114, 90, -118, -84, -86, 104, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    public static byte[] getP15() {
        return DHGroupData.getOakleyGroupPrimeValue("group15.prime");
    }

    public static byte[] getP16() {
        return DHGroupData.getOakleyGroupPrimeValue("group16.prime");
    }

    public static byte[] getP17() {
        return DHGroupData.getOakleyGroupPrimeValue("group17.prime");
    }

    public static byte[] getP18() {
        return DHGroupData.getOakleyGroupPrimeValue("group18.prime");
    }

    public static byte[] getOakleyGroupPrimeValue(String string) {
        byte[] byArray = OAKLEY_GROUPS.computeIfAbsent(string, DHGroupData::readOakleyGroupPrimeValue);
        return byArray == null ? null : (byte[])byArray.clone();
    }

    public static byte[] readOakleyGroupPrimeValue(String string) {
        byte[] byArray;
        block9: {
            InputStream inputStream = DHGroupData.class.getResourceAsStream(string);
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException("Resource not found: " + string);
                }
                byArray = DHGroupData.readOakleyGroupPrimeValue(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] readOakleyGroupPrimeValue(InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            byte[] byArray = DHGroupData.readOakleyGroupPrimeValue(inputStreamReader);
            return byArray;
        }
    }

    public static byte[] readOakleyGroupPrimeValue(Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            byte[] byArray = DHGroupData.readOakleyGroupPrimeValue(bufferedReader);
            return byArray;
        }
    }

    public static byte[] readOakleyGroupPrimeValue(BufferedReader bufferedReader) {
        try {
            byte[] byArray = DHGroupData.readOakleyGroupPrimeValue(bufferedReader.lines());
            if (NumberUtils.isEmpty(byArray)) {
                throw new EOFException("No prime value data found");
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new StreamCorruptedException("Invalid value: " + numberFormatException.getMessage());
        }
    }

    public static byte[] readOakleyGroupPrimeValue(Stream stream) {
        String string2 = stream.map(GenericUtils::trimToEmpty).map(string -> string.replaceAll("\\s", "")).filter(GenericUtils::isNotEmpty).filter(string -> !string.startsWith("#")).collect(Collectors.joining());
        return DHGroupData.parseOakleyGroupPrimeValue(string2);
    }

    public static byte[] parseOakleyGroupPrimeValue(String string) {
        int n2 = GenericUtils.length(string);
        if (n2 <= 0) {
            return GenericUtils.EMPTY_BYTE_ARRAY;
        }
        if ((n2 & 1) != 0) {
            throw new NumberFormatException("Incomplete HEX value representation");
        }
        byte[] byArray = new byte[n2 / 2 + 1];
        byArray[0] = 0;
        int n3 = 1;
        int n4 = 0;
        while (n3 < byArray.length) {
            char c2 = string.charAt(n4);
            char c3 = string.charAt(n4 + 1);
            byArray[n3] = BufferUtils.fromHex(c2, c3);
            ++n3;
            n4 += 2;
        }
        return byArray;
    }
}

