/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.util.security.SecurityUtils;

public class DHG
extends AbstractDH {
    public static final String KEX_TYPE = "DH";
    private BigInteger p;
    private BigInteger g;
    private BigInteger f;
    private Factory factory;

    public DHG(Factory factory) {
        this(factory, null, null);
    }

    public DHG(Factory factory, BigInteger bigInteger, BigInteger bigInteger2) {
        this.myKeyAgree = SecurityUtils.getKeyAgreement(KEX_TYPE);
        this.factory = factory;
        this.p = bigInteger;
        this.g = bigInteger2;
    }

    @Override
    protected byte[] calculateE() {
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.p, this.g);
        KeyPairGenerator keyPairGenerator = SecurityUtils.getKeyPairGenerator(KEX_TYPE);
        keyPairGenerator.initialize(dHParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        DHPublicKey dHPublicKey = (DHPublicKey)keyPair.getPublic();
        BigInteger bigInteger = dHPublicKey.getY();
        return bigInteger.toByteArray();
    }

    @Override
    protected byte[] calculateK() {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(this.f, this.p, this.g);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(KEX_TYPE);
        PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
        this.myKeyAgree.doPhase(publicKey, true);
        return DHG.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setP(byte[] byArray) {
        this.setP(new BigInteger(byArray));
    }

    public void setG(byte[] byArray) {
        this.setG(new BigInteger(byArray));
    }

    @Override
    public void setF(byte[] byArray) {
        this.setF(new BigInteger(byArray));
    }

    public BigInteger getP() {
        return this.p;
    }

    public void setP(BigInteger bigInteger) {
        this.p = bigInteger;
    }

    public BigInteger getG() {
        return this.g;
    }

    public void setG(BigInteger bigInteger) {
        this.g = bigInteger;
    }

    public void setF(BigInteger bigInteger) {
        this.f = Objects.requireNonNull(bigInteger, "No 'f' value specified");
    }

    @Override
    public Digest getHash() {
        return (Digest)this.factory.create();
    }

    @Override
    public String toString() {
        return super.toString() + "[p=" + this.p + ", g=" + this.g + ", f=" + this.f + ", digest=" + this.factory + "]";
    }
}

