/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.kex.BuiltinDHFactories$1;
import org.apache.sshd.common.kex.BuiltinDHFactories$10;
import org.apache.sshd.common.kex.BuiltinDHFactories$11;
import org.apache.sshd.common.kex.BuiltinDHFactories$12;
import org.apache.sshd.common.kex.BuiltinDHFactories$13;
import org.apache.sshd.common.kex.BuiltinDHFactories$14;
import org.apache.sshd.common.kex.BuiltinDHFactories$15;
import org.apache.sshd.common.kex.BuiltinDHFactories$2;
import org.apache.sshd.common.kex.BuiltinDHFactories$3;
import org.apache.sshd.common.kex.BuiltinDHFactories$4;
import org.apache.sshd.common.kex.BuiltinDHFactories$5;
import org.apache.sshd.common.kex.BuiltinDHFactories$6;
import org.apache.sshd.common.kex.BuiltinDHFactories$7;
import org.apache.sshd.common.kex.BuiltinDHFactories$8;
import org.apache.sshd.common.kex.BuiltinDHFactories$9;
import org.apache.sshd.common.kex.BuiltinDHFactories$ParseResult;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class BuiltinDHFactories
extends Enum
implements DHFactory {
    @Deprecated
    public static final /* enum */ BuiltinDHFactories dhg1 = new BuiltinDHFactories$1("diffie-hellman-group1-sha1");
    @Deprecated
    public static final /* enum */ BuiltinDHFactories dhg14 = new BuiltinDHFactories$2("diffie-hellman-group14-sha1");
    public static final /* enum */ BuiltinDHFactories dhg14_256 = new BuiltinDHFactories$3("diffie-hellman-group14-sha256");
    public static final /* enum */ BuiltinDHFactories dhg15_512 = new BuiltinDHFactories$4("diffie-hellman-group15-sha512");
    public static final /* enum */ BuiltinDHFactories dhg16_512 = new BuiltinDHFactories$5("diffie-hellman-group16-sha512");
    public static final /* enum */ BuiltinDHFactories dhg17_512 = new BuiltinDHFactories$6("diffie-hellman-group17-sha512");
    public static final /* enum */ BuiltinDHFactories dhg18_512 = new BuiltinDHFactories$7("diffie-hellman-group18-sha512");
    @Deprecated
    public static final /* enum */ BuiltinDHFactories dhgex = new BuiltinDHFactories$8("diffie-hellman-group-exchange-sha1");
    public static final /* enum */ BuiltinDHFactories dhgex256 = new BuiltinDHFactories$9("diffie-hellman-group-exchange-sha256");
    public static final /* enum */ BuiltinDHFactories ecdhp256 = new BuiltinDHFactories$10("ecdh-sha2-nistp256");
    public static final /* enum */ BuiltinDHFactories ecdhp384 = new BuiltinDHFactories$11("ecdh-sha2-nistp384");
    public static final /* enum */ BuiltinDHFactories ecdhp521 = new BuiltinDHFactories$12("ecdh-sha2-nistp521");
    public static final /* enum */ BuiltinDHFactories curve25519 = new BuiltinDHFactories$13("curve25519-sha256");
    public static final /* enum */ BuiltinDHFactories curve25519_libssh = new BuiltinDHFactories$14("curve25519-sha256@libssh.org");
    public static final /* enum */ BuiltinDHFactories curve448 = new BuiltinDHFactories$15("curve448-sha512");
    public static final Set VALUES;
    private static final Map EXTENSIONS;
    private final String factoryName;
    private static final /* synthetic */ BuiltinDHFactories[] $VALUES;

    public static BuiltinDHFactories[] values() {
        return (BuiltinDHFactories[])$VALUES.clone();
    }

    public static BuiltinDHFactories valueOf(String string) {
        return Enum.valueOf(BuiltinDHFactories.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinDHFactories() {
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.factoryName = var3_2;
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(DHFactory dHFactory) {
        String string = Objects.requireNonNull(dHFactory, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinDHFactories.fromFactoryName(string) == null, "Extension overrides built-in: %s", (Object)string);
        Map map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(string), "Extension overrides existing: %s", (Object)string);
            EXTENSIONS.put(string, dHFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensions() {
        Map map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory unregisterExtension(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (DHFactory)EXTENSIONS.remove(string);
        }
    }

    public static BuiltinDHFactories fromFactoryName(String string) {
        return (BuiltinDHFactories)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    @Override
    public boolean isGroupExchange() {
        return false;
    }

    public static BuiltinDHFactories$ParseResult parseDHFactoriesList(String string) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.split(string, ','));
    }

    public static BuiltinDHFactories$ParseResult parseDHFactoriesList(String ... stringArray) {
        return BuiltinDHFactories.parseDHFactoriesList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinDHFactories$ParseResult parseDHFactoriesList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinDHFactories$ParseResult.EMPTY;
        }
        ArrayList<DHFactory> arrayList = new ArrayList<DHFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            DHFactory dHFactory = BuiltinDHFactories.resolveFactory(string);
            if (dHFactory != null) {
                arrayList.add(dHFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinDHFactories$ParseResult(arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        BuiltinDHFactories builtinDHFactories = BuiltinDHFactories.fromFactoryName(string);
        if (builtinDHFactories != null) {
            return builtinDHFactories;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (DHFactory)EXTENSIONS.get(string);
        }
    }

    private static /* synthetic */ BuiltinDHFactories[] $values() {
        return new BuiltinDHFactories[]{dhg1, dhg14, dhg14_256, dhg15_512, dhg16_512, dhg17_512, dhg18_512, dhgex, dhgex256, ecdhp256, ecdhp384, ecdhp521, curve25519, curve25519_libssh, curve448};
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinDHFactories(String string, BuiltinDHFactories$1 builtinDHFactories$1) {
        this((String)var1_-1, (int)builtinDHFactories$1, (String)var3_2);
        void var3_2;
        void var1_-1;
    }

    static {
        $VALUES = BuiltinDHFactories.$values();
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinDHFactories.class));
        EXTENSIONS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }
}

