/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import javax.crypto.KeyAgreement;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class AbstractDH {
    protected KeyAgreement myKeyAgree;
    private byte[] k_array;
    private byte[] e_array;

    protected AbstractDH() {
    }

    public abstract void setF(byte[] var1);

    public boolean isPublicDataAvailable() {
        return this.e_array != null;
    }

    protected abstract byte[] calculateE();

    public byte[] getE() {
        if (this.e_array == null) {
            this.e_array = this.calculateE();
            this.checkKeyAgreementNecessity();
        }
        return this.e_array;
    }

    public void putE(Buffer buffer, byte[] byArray) {
        buffer.putMPInt(byArray);
    }

    public void putF(Buffer buffer, byte[] byArray) {
        buffer.putMPInt(byArray);
    }

    public boolean isSharedSecretAvailable() {
        return this.k_array != null;
    }

    protected abstract byte[] calculateK();

    public byte[] getK() {
        if (this.k_array == null) {
            this.k_array = this.calculateK();
            this.checkKeyAgreementNecessity();
        }
        return this.k_array;
    }

    protected void checkKeyAgreementNecessity() {
        if (this.e_array == null || this.k_array == null) {
            return;
        }
        if (this.myKeyAgree != null) {
            this.myKeyAgree = null;
        }
    }

    public abstract Digest getHash();

    public String toString() {
        return this.getClass().getSimpleName() + "[publicDataAvailable=" + this.isPublicDataAvailable() + ", sharedSecretAvailable=" + this.isSharedSecretAvailable() + "]";
    }

    public static byte[] stripLeadingZeroes(byte[] byArray) {
        int n2 = NumberUtils.length(byArray);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            if (i2 == 0) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2 - i2];
            System.arraycopy(byArray, i2, byArray2, 0, byArray2.length);
            return byArray2;
        }
        throw new IllegalArgumentException("No non-zero values in generated secret");
    }
}

