/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.io.WriteAbortedException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session$1;
import org.apache.sshd.common.io.nio2.Nio2Session$2;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class Nio2Session
extends AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler ioHandler;
    private final AsynchronousSocketChannel socketChannel;
    private final Map attributes = new HashMap();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress acceptanceAddress;
    private final PropertyResolver propertyResolver;
    private final Queue writes = new LinkedTransferQueue();
    private final AtomicReference currentWrite = new AtomicReference();
    private final AtomicLong readCyclesCounter = new AtomicLong();
    private final AtomicLong lastReadCycleStart = new AtomicLong();
    private final AtomicLong writeCyclesCounter = new AtomicLong();
    private final AtomicLong lastWriteCycleStart = new AtomicLong();
    private final AtomicBoolean outputShutDown = new AtomicBoolean();
    private final Object suspendLock = new Object();
    private volatile boolean suspend;
    private volatile Runnable readRunnable;
    private Thread readerThread;

    public Nio2Session(Nio2Service nio2Service, PropertyResolver propertyResolver, IoHandler ioHandler, AsynchronousSocketChannel asynchronousSocketChannel, SocketAddress socketAddress) {
        this.service = Objects.requireNonNull(nio2Service, "No service instance");
        this.propertyResolver = Objects.requireNonNull(propertyResolver, "No property resolver");
        this.ioHandler = Objects.requireNonNull(ioHandler, "No IoHandler");
        this.socketChannel = Objects.requireNonNull(asynchronousSocketChannel, "No socket channel");
        this.localAddress = asynchronousSocketChannel.getLocalAddress();
        this.remoteAddress = asynchronousSocketChannel.getRemoteAddress();
        this.acceptanceAddress = socketAddress;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating IoSession on {} from {} via {}", new Object[]{this.localAddress, this.remoteAddress, socketAddress});
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(Object object) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(Object object, Object object2) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttributeIfAbsent(Object object, Object object2) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeAttribute(Object object) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(object);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public AsynchronousSocketChannel getSocket() {
        return this.socketChannel;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void suspend() {
        block4: {
            AsynchronousSocketChannel asynchronousSocketChannel = this.getSocket();
            try {
                asynchronousSocketChannel.shutdownInput();
            }
            catch (IOException iOException) {
                this.debug("suspend({}) failed ({}) to shutdown input: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
            }
            try {
                asynchronousSocketChannel.shutdownOutput();
            }
            catch (IOException iOException) {
                if (!this.log.isDebugEnabled()) break block4;
                this.debug("suspend({}) failed ({}) to shutdown output: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("writeBuffer({}) writing {} bytes", (Object)this, (Object)buffer.available());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture = new Nio2DefaultIoWriteFuture(this.getRemoteAddress(), null, byteBuffer);
        if (this.isClosing()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            nio2DefaultIoWriteFuture.setException(closedChannelException);
            this.exceptionCaught(closedChannelException);
            return nio2DefaultIoWriteFuture;
        }
        this.writes.add(nio2DefaultIoWriteFuture);
        this.startWriting();
        return nio2DefaultIoWriteFuture;
    }

    protected void exceptionCaught(Throwable throwable) {
        if (this.closeFuture.isClosed()) {
            return;
        }
        AsynchronousSocketChannel asynchronousSocketChannel = this.getSocket();
        if (this.isOpen() && asynchronousSocketChannel.isOpen()) {
            IoHandler ioHandler = this.getIoHandler();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("exceptionCaught({}) caught {}[{}] - calling handler", new Object[]{this, throwable.getClass().getSimpleName(), throwable.getMessage()});
                }
                ioHandler.exceptionCaught(this, throwable);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = ExceptionUtils.peelException(throwable2);
                this.debug("exceptionCaught({}) Exception handler threw {}, closing the session: {}", this, throwable3.getClass().getSimpleName(), throwable3.getMessage(), throwable3);
            }
        }
        this.close(true);
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        String string = this.toString();
        return this.builder().when(string, this.writes).run(string, () -> {
            try {
                AsynchronousSocketChannel asynchronousSocketChannel = this.getSocket();
                if (asynchronousSocketChannel.isOpen()) {
                    asynchronousSocketChannel.shutdownOutput();
                }
            }
            catch (IOException iOException) {
                this.log.trace("doCloseGracefully({}) {} while shutting down output: {}", new Object[]{this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException});
            }
        }).build().close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        Object object;
        Object object2;
        boolean bl2 = this.log.isDebugEnabled();
        while ((object2 = (Nio2DefaultIoWriteFuture)this.writes.poll()) != null) {
            if (((AbstractIoWriteFuture)object2).isWritten()) {
                if (!bl2) continue;
                this.log.debug("doCloseImmediately({}) skip already written future={}", (Object)this, object2);
                continue;
            }
            object = ((AbstractIoWriteFuture)object2).getException();
            if (object != null) continue;
            if (bl2) {
                this.log.debug("doCloseImmediately({}) signal write abort for future={}", (Object)this, object2);
            }
            ((Nio2DefaultIoWriteFuture)object2).setException(new WriteAbortedException("Write request aborted due to immediate session close", null));
        }
        object2 = this.getSocket();
        try {
            if (bl2) {
                this.log.debug("doCloseImmediately({}) closing socket={}", (Object)this, object2);
            }
            object2.close();
            if (bl2) {
                this.log.debug("doCloseImmediately({}) socket={} closed", (Object)this, object2);
            }
        }
        catch (IOException iOException) {
            this.debug("doCloseImmediately({}) {} caught while closing socket={}: {}", this, iOException.getClass().getSimpleName(), object2, iOException.getMessage(), iOException);
        }
        this.service.sessionClosed(this);
        super.doCloseImmediately();
        object = this.getIoHandler();
        try {
            object.sessionClosed(this);
        }
        catch (Throwable throwable) {
            this.debug("doCloseImmediately({}) {} while calling IoHandler#sessionClosed: {}", this, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        }
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
        }
    }

    @Override
    public Nio2Service getService() {
        return this.service;
    }

    @Override
    public void shutdownOutputStream() {
        if (this.outputShutDown.compareAndSet(false, true)) {
            Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture = new Nio2DefaultIoWriteFuture("shutdown-" + this.getRemoteAddress(), null, null);
            this.writes.add(nio2DefaultIoWriteFuture);
            this.startWriting();
        }
    }

    protected void doShutdownOutputStream(Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture, AsynchronousSocketChannel asynchronousSocketChannel) {
        try {
            block6: {
                if (asynchronousSocketChannel.isOpen()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doShutdownOutputStream({})", (Object)this);
                    }
                    try {
                        asynchronousSocketChannel.shutdownOutput();
                    }
                    catch (ClosedChannelException closedChannelException) {
                        if (!this.log.isTraceEnabled()) break block6;
                        this.log.trace("doShutdownOutputStream({}): socket is already closed", (Object)this);
                    }
                }
            }
            this.writes.remove(nio2DefaultIoWriteFuture);
            nio2DefaultIoWriteFuture.setWritten();
            this.finishWrite(nio2DefaultIoWriteFuture);
        }
        catch (Exception exception) {
            this.handleWriteCycleFailure(nio2DefaultIoWriteFuture, asynchronousSocketChannel, null, 0, exception, null);
        }
    }

    public void startReading() {
        this.startReading((Integer)CoreModuleProperties.NIO2_READ_BUFFER_SIZE.getRequired(this.propertyResolver));
    }

    public void startReading(int n2) {
        this.startReading(new byte[n2]);
    }

    public void startReading(byte[] byArray) {
        this.startReading(byArray, 0, byArray.length);
    }

    public void startReading(byte[] byArray, int n2, int n3) {
        this.startReading(ByteBuffer.wrap(byArray, n2, n3));
    }

    public void startReading(ByteBuffer byteBuffer) {
        this.doReadCycle(byteBuffer, Readable.readable(byteBuffer));
    }

    protected void doReadCycle(ByteBuffer byteBuffer, Readable readable) {
        Nio2CompletionHandler nio2CompletionHandler = Objects.requireNonNull(this.createReadCycleCompletionHandler(byteBuffer, readable), "No completion handler created");
        this.doReadCycle(byteBuffer, nio2CompletionHandler);
    }

    protected Nio2CompletionHandler createReadCycleCompletionHandler(ByteBuffer byteBuffer, Readable readable) {
        return new Nio2Session$1(this, byteBuffer, readable);
    }

    protected void handleReadCycleCompletion(ByteBuffer byteBuffer, Readable readable, Nio2CompletionHandler nio2CompletionHandler, Integer n2, Object object) {
        try {
            boolean bl2 = this.log.isDebugEnabled();
            if (n2 >= 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("handleReadCycleCompletion({}) read {} bytes after {} nanos at cycle={}", new Object[]{this, n2, System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter});
                }
                byteBuffer.flip();
                IoHandler ioHandler = this.getIoHandler();
                ioHandler.messageReceived(this, readable);
                if (!this.closeFuture.isClosed()) {
                    this.doReadCycle(byteBuffer, nio2CompletionHandler);
                } else if (bl2) {
                    this.log.debug("handleReadCycleCompletion({}) IoSession has been closed, stop reading", (Object)this);
                }
            } else {
                if (bl2) {
                    this.log.debug("handleReadCycleCompletion({}) Socket has been disconnected (result={}), closing IoSession now", (Object)this, (Object)n2);
                }
                this.close(true);
            }
        }
        catch (Throwable throwable) {
            nio2CompletionHandler.failed(throwable, object);
        }
    }

    protected void handleReadCycleFailure(ByteBuffer byteBuffer, Readable readable, Throwable throwable, Object object) {
        this.debug("handleReadCycleFailure({}) {} after {} nanos at read cycle={}: {}", this, throwable.getClass().getSimpleName(), System.nanoTime() - this.lastReadCycleStart.get(), this.readCyclesCounter, throwable.getMessage(), throwable);
        this.exceptionCaught(throwable);
    }

    @Override
    public void suspendRead() {
        this.log.trace("suspendRead({})", (Object)this);
        boolean bl2 = this.suspend;
        this.suspend = true;
        if (!bl2) {
            this.log.debug("suspendRead({}) requesting read suspension", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeRead() {
        this.log.trace("resumeRead({})", (Object)this);
        if (this.suspend) {
            Runnable runnable;
            Object object = this.suspendLock;
            synchronized (object) {
                this.suspend = false;
                runnable = this.readRunnable;
                this.readRunnable = null;
            }
            if (runnable != null && !Thread.currentThread().equals(this.readerThread)) {
                this.log.debug("resumeRead({}) resuming read", (Object)this);
                this.service.getExecutorService().execute(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReadCycle(ByteBuffer byteBuffer, Nio2CompletionHandler nio2CompletionHandler) {
        Object object;
        if (this.suspend) {
            this.log.debug("doReadCycle({}) suspending reading", (Object)this);
            object = this.suspendLock;
            synchronized (object) {
                if (this.suspend) {
                    this.readRunnable = () -> this.doReadCycle(byteBuffer, nio2CompletionHandler);
                    return;
                }
            }
        }
        object = this.getSocket();
        Duration duration = (Duration)CoreModuleProperties.NIO2_READ_TIMEOUT.getRequired(this.propertyResolver);
        this.readCyclesCounter.incrementAndGet();
        this.lastReadCycleStart.set(System.nanoTime());
        byteBuffer.clear();
        ((AsynchronousSocketChannel)object).read(byteBuffer, duration.toMillis(), TimeUnit.MILLISECONDS, null, nio2CompletionHandler);
    }

    protected void startWriting() {
        Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture = (Nio2DefaultIoWriteFuture)this.writes.peek();
        if (nio2DefaultIoWriteFuture == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, nio2DefaultIoWriteFuture)) {
            return;
        }
        try {
            AsynchronousSocketChannel asynchronousSocketChannel = this.getSocket();
            ByteBuffer byteBuffer = nio2DefaultIoWriteFuture.getBuffer();
            if (byteBuffer == null) {
                this.doShutdownOutputStream(nio2DefaultIoWriteFuture, asynchronousSocketChannel);
            } else {
                Nio2CompletionHandler nio2CompletionHandler = Objects.requireNonNull(this.createWriteCycleCompletionHandler(nio2DefaultIoWriteFuture, asynchronousSocketChannel, byteBuffer), "No write cycle completion handler created");
                this.doWriteCycle(byteBuffer, nio2CompletionHandler);
            }
        }
        catch (Throwable throwable) {
            nio2DefaultIoWriteFuture.setWritten();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeSshException(throwable);
        }
    }

    protected void doWriteCycle(ByteBuffer byteBuffer, Nio2CompletionHandler nio2CompletionHandler) {
        AsynchronousSocketChannel asynchronousSocketChannel = this.getSocket();
        Duration duration = (Duration)CoreModuleProperties.NIO2_MIN_WRITE_TIMEOUT.getRequired(this.propertyResolver);
        this.writeCyclesCounter.incrementAndGet();
        this.lastWriteCycleStart.set(System.nanoTime());
        asynchronousSocketChannel.write(byteBuffer, duration.toMillis(), TimeUnit.MILLISECONDS, null, nio2CompletionHandler);
    }

    protected Nio2CompletionHandler createWriteCycleCompletionHandler(Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture, AsynchronousSocketChannel asynchronousSocketChannel, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        return new Nio2Session$2(this, nio2DefaultIoWriteFuture, asynchronousSocketChannel, byteBuffer, n2);
    }

    protected void handleCompletedWriteCycle(Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture, AsynchronousSocketChannel asynchronousSocketChannel, ByteBuffer byteBuffer, int n2, Nio2CompletionHandler nio2CompletionHandler, Integer n3, Object object) {
        if (byteBuffer.hasRemaining()) {
            try {
                asynchronousSocketChannel.write(byteBuffer, null, nio2CompletionHandler);
            }
            catch (Throwable throwable) {
                this.debug("handleCompletedWriteCycle({}) {} while writing to socket len={}: {}", this, throwable.getClass().getSimpleName(), n2, throwable.getMessage(), throwable);
                nio2DefaultIoWriteFuture.setWritten();
                this.finishWrite(nio2DefaultIoWriteFuture);
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleCompletedWriteCycle({}) finished writing len={} at cycle={} after {} nanos", new Object[]{this, n2, this.writeCyclesCounter, System.nanoTime() - this.lastWriteCycleStart.get()});
            }
            this.writes.remove(nio2DefaultIoWriteFuture);
            nio2DefaultIoWriteFuture.setWritten();
            this.finishWrite(nio2DefaultIoWriteFuture);
        }
    }

    protected void handleWriteCycleFailure(Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture, AsynchronousSocketChannel asynchronousSocketChannel, ByteBuffer byteBuffer, int n2, Throwable throwable, Object object) {
        block3: {
            if (this.log.isDebugEnabled()) {
                this.debug("handleWriteCycleFailure({}) failed ({}) to write {} bytes at write cycle={} after {} nanos: {}", this, throwable.getClass().getSimpleName(), n2, this.writeCyclesCounter, System.nanoTime() - this.lastWriteCycleStart.get(), throwable.getMessage(), throwable);
            }
            nio2DefaultIoWriteFuture.setException(throwable);
            this.exceptionCaught(throwable);
            try {
                this.finishWrite(nio2DefaultIoWriteFuture);
            }
            catch (RuntimeException runtimeException) {
                if (!this.log.isTraceEnabled()) break block3;
                this.log.trace("handleWriteCycleFailure({}) failed ({}) to finish writing: {}", new Object[]{this, runtimeException.getClass().getSimpleName(), runtimeException.getMessage()});
            }
        }
    }

    protected void finishWrite(Nio2DefaultIoWriteFuture nio2DefaultIoWriteFuture) {
        this.writes.remove(nio2DefaultIoWriteFuture);
        this.currentWrite.compareAndSet(nio2DefaultIoWriteFuture, null);
        this.startWriting();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }

    static /* synthetic */ Thread access$002(Nio2Session nio2Session, Thread thread) {
        nio2Session.readerThread = thread;
        return nio2Session.readerThread;
    }
}

