/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.AbstractIoServiceFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;

public class Nio2ServiceFactory
extends AbstractIoServiceFactory {
    private final AsynchronousChannelGroup group;
    private final CloseableExecutorService resuming;

    public Nio2ServiceFactory(FactoryManager factoryManager, CloseableExecutorService closeableExecutorService, CloseableExecutorService closeableExecutorService2) {
        super(factoryManager, ThreadUtils.newFixedThreadPoolIf(closeableExecutorService, factoryManager.toString() + "-nio2", Nio2ServiceFactory.getNioWorkers(factoryManager)));
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(ThreadUtils.noClose(this.getExecutorService()));
            this.resuming = ThreadUtils.newFixedThreadPoolIf(closeableExecutorService2, factoryManager.toString() + "-nio2-resume", Nio2ServiceFactory.getNioWorkers(factoryManager));
        }
        catch (IOException iOException) {
            this.warn("Failed ({}) to start async. channel group: {}", iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
            throw new RuntimeSshException(iOException);
        }
    }

    @Override
    public IoConnector createConnector(IoHandler ioHandler) {
        return (IoConnector)this.autowireCreatedService(new Nio2Connector(this, this.getFactoryManager(), ioHandler, this.group, this.resuming));
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler ioHandler) {
        return (IoAcceptor)this.autowireCreatedService(new Nio2Acceptor(this, this.getFactoryManager(), ioHandler, this.group, this.resuming));
    }

    public Nio2Session createSession(Nio2Service nio2Service, IoHandler ioHandler, AsynchronousSocketChannel asynchronousSocketChannel, SocketAddress socketAddress) {
        return new Nio2Session(nio2Service, this.getFactoryManager(), ioHandler, asynchronousSocketChannel, socketAddress);
    }

    @Override
    protected void doCloseImmediately() {
        try {
            if (!this.resuming.isShutdown()) {
                this.resuming.shutdownNow();
            }
            if (!this.group.isShutdown()) {
                this.log.debug("Shutdown group");
                this.group.shutdownNow();
                if (this.group.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.debug("Group successfully shut down");
                } else {
                    this.log.debug("Not all group tasks terminated");
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Exception caught while closing channel group", (Throwable)exception);
        }
        finally {
            super.doCloseImmediately();
        }
    }
}

