/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.NetworkChannel;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Property;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class Nio2Service
extends AbstractInnerCloseable
implements IoService {
    public static final Map CONFIGURABLE_OPTIONS;
    protected final Map sessions;
    protected final AtomicBoolean disposing = new AtomicBoolean();
    protected final PropertyResolver propertyResolver;
    private final IoHandler handler;
    private final AsynchronousChannelGroup group;
    private final ExecutorService executor;
    private IoServiceEventListener eventListener;

    protected Nio2Service(PropertyResolver propertyResolver, IoHandler ioHandler, AsynchronousChannelGroup asynchronousChannelGroup, ExecutorService executorService) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Creating {}", (Object)this.getClass().getSimpleName());
        }
        this.propertyResolver = Objects.requireNonNull(propertyResolver, "No property resolver provided");
        this.handler = Objects.requireNonNull(ioHandler, "No I/O handler provided");
        this.group = Objects.requireNonNull(asynchronousChannelGroup, "No async. channel group provided");
        this.executor = Objects.requireNonNull(executorService, "No executor for resuming suspended sessions provided");
        this.sessions = new ConcurrentHashMap();
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener ioServiceEventListener) {
        this.eventListener = ioServiceEventListener;
    }

    protected AsynchronousChannelGroup getChannelGroup() {
        return this.group;
    }

    protected ExecutorService getExecutorService() {
        return this.executor;
    }

    public IoHandler getIoHandler() {
        return this.handler;
    }

    public void dispose() {
        try {
            if (this.disposing.getAndSet(true)) {
                this.log.warn("dispose({}) already disposing", (Object)this);
            }
            Duration duration = Closeable.getMaxCloseWaitTime(this.propertyResolver);
            boolean bl2 = this.close(true).await(duration);
            if (!bl2) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + duration);
            }
        }
        catch (IOException iOException) {
            this.warn("dispose({}) {} while stopping service: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.sessions.values()).build();
    }

    @Override
    public Map getManagedSessions() {
        return Collections.unmodifiableMap(this.sessions);
    }

    public void sessionClosed(Nio2Session nio2Session) {
        this.unmapSession(nio2Session.getId());
    }

    protected void unmapSession(Long l2) {
        if (l2 != null) {
            IoSession ioSession = (IoSession)this.sessions.remove(l2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("unmapSession(id={}): {}", (Object)l2, (Object)ioSession);
            }
        }
    }

    protected NetworkChannel setSocketOptions(NetworkChannel networkChannel) {
        Set<SocketOption<?>> set = networkChannel.supportedOptions();
        if (GenericUtils.isEmpty(set)) {
            return networkChannel;
        }
        for (Map.Entry entry : CONFIGURABLE_OPTIONS.entrySet()) {
            Property property = (Property)entry.getKey();
            Map.Entry entry2 = (Map.Entry)entry.getValue();
            SocketOption socketOption = (SocketOption)entry2.getKey();
            this.setOption(networkChannel, property, socketOption, entry2.getValue());
        }
        return networkChannel;
    }

    protected boolean setOption(NetworkChannel networkChannel, Property property, SocketOption socketOption, Object object) {
        Object object2;
        String string = this.propertyResolver.getString(property.getName());
        Object object3 = object;
        if (!GenericUtils.isEmpty(string)) {
            object2 = socketOption.type();
            if (object2 == Integer.class) {
                object3 = ((Class)object2).cast(Integer.valueOf(string));
            } else if (object2 == Boolean.class) {
                object3 = ((Class)object2).cast(Boolean.valueOf(string));
            } else {
                throw new IllegalStateException("Unsupported socket option type (" + object2 + ") " + property + "=" + string);
            }
        }
        if (object3 == null) {
            return false;
        }
        object2 = networkChannel.supportedOptions();
        if (GenericUtils.isEmpty((Collection)object2) || !object2.contains(socketOption)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unsupported socket option ({}) to set using {}={}", new Object[]{socketOption, property, object3});
            }
            return false;
        }
        try {
            networkChannel.setOption(socketOption, object3);
            if (this.log.isDebugEnabled()) {
                this.log.debug("setOption({})[{}] from property={}", new Object[]{socketOption, object3, property});
            }
            return true;
        }
        catch (IOException | RuntimeException exception) {
            this.log.warn("setOption({}): unable to set socket option {} via {}={}: {}", new Object[]{networkChannel, socketOption, property, object3, exception.toString()});
            return false;
        }
    }

    static {
        LinkedHashMap<Property, AbstractMap.SimpleImmutableEntry<SocketOption<Comparable<Boolean>>, Object>> linkedHashMap = new LinkedHashMap<Property, AbstractMap.SimpleImmutableEntry<SocketOption<Comparable<Boolean>>, Object>>();
        linkedHashMap.put(CoreModuleProperties.SOCKET_KEEPALIVE, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Object>(StandardSocketOptions.SO_KEEPALIVE, null));
        linkedHashMap.put(CoreModuleProperties.SOCKET_LINGER, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_LINGER, null));
        linkedHashMap.put(CoreModuleProperties.SOCKET_RCVBUF, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_RCVBUF, null));
        linkedHashMap.put(CoreModuleProperties.SOCKET_REUSEADDR, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Boolean>(StandardSocketOptions.SO_REUSEADDR, true));
        linkedHashMap.put(CoreModuleProperties.SOCKET_SNDBUF, new AbstractMap.SimpleImmutableEntry<SocketOption<Integer>, Object>(StandardSocketOptions.SO_SNDBUF, null));
        linkedHashMap.put(CoreModuleProperties.TCP_NODELAY, new AbstractMap.SimpleImmutableEntry<SocketOption<Boolean>, Object>(StandardSocketOptions.TCP_NODELAY, null));
        CONFIGURABLE_OPTIONS = Collections.unmodifiableMap(linkedHashMap);
    }
}

