/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.io.DefaultIoConnectFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Connector$ConnectionCompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;

public class Nio2Connector
extends Nio2Service
implements IoConnector {
    private final Nio2ServiceFactory nio2ServiceFactory;

    public Nio2Connector(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler ioHandler, AsynchronousChannelGroup asynchronousChannelGroup, ExecutorService executorService) {
        super(propertyResolver, ioHandler, asynchronousChannelGroup, executorService);
        this.nio2ServiceFactory = nio2ServiceFactory;
    }

    @Override
    public IoConnectFuture connect(SocketAddress socketAddress, AttributeRepository attributeRepository, SocketAddress socketAddress2) {
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("Connecting to {}", (Object)socketAddress);
        }
        DefaultIoConnectFuture defaultIoConnectFuture = new DefaultIoConnectFuture(socketAddress, null);
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        AsynchronousSocketChannel asynchronousSocketChannel2 = null;
        try {
            AsynchronousChannelGroup asynchronousChannelGroup = this.getChannelGroup();
            asynchronousSocketChannel = this.openAsynchronousSocketChannel(socketAddress, asynchronousChannelGroup);
            asynchronousSocketChannel2 = (AsynchronousSocketChannel)this.setSocketOptions(asynchronousSocketChannel);
            if (socketAddress2 != null) {
                asynchronousSocketChannel2.bind(socketAddress2);
            }
            Nio2CompletionHandler nio2CompletionHandler = (Nio2CompletionHandler)ValidateUtils.checkNotNull((Object)this.createConnectionCompletionHandler(defaultIoConnectFuture, asynchronousSocketChannel2, attributeRepository, this.propertyResolver, this.getIoHandler()), "No connection completion handler created for %s", (Object)socketAddress);
            Future<Void> future = asynchronousSocketChannel2.connect(socketAddress);
            Long l2 = CoreModuleProperties.IO_CONNECT_TIMEOUT.get(this.propertyResolver).map(duration -> {
                long l2;
                if (duration.isZero() || duration.isNegative()) {
                    return null;
                }
                try {
                    l2 = duration.toMillis();
                }
                catch (ArithmeticException arithmeticException) {
                    l2 = Long.MAX_VALUE;
                }
                return l2;
            }).orElse(null);
            Future<?> future2 = this.getExecutorService().submit(() -> {
                try {
                    if (l2 != null) {
                        this.log.debug("connect({}): waiting for connection (timeout={}ms)", (Object)socketAddress, (Object)l2);
                        future.get(l2, TimeUnit.MILLISECONDS);
                    } else {
                        this.log.debug("connect({}): waiting for connection", (Object)socketAddress);
                        future.get();
                    }
                    nio2CompletionHandler.onCompleted(null, null);
                }
                catch (CancellationException cancellationException) {
                    CancelFuture cancelFuture = defaultIoConnectFuture.cancel();
                    if (cancelFuture != null) {
                        cancelFuture.setCanceled(cancellationException);
                    }
                }
                catch (TimeoutException timeoutException) {
                    future.cancel(true);
                    ConnectException connectException = new ConnectException("I/O connection time-out of " + l2 + "ms expired");
                    connectException.initCause(timeoutException);
                    nio2CompletionHandler.onFailed(connectException, null);
                }
                catch (ExecutionException executionException) {
                    nio2CompletionHandler.onFailed(executionException, null);
                }
                catch (InterruptedException interruptedException) {
                    nio2CompletionHandler.onFailed(interruptedException, null);
                    Thread.currentThread().interrupt();
                }
            });
            defaultIoConnectFuture.addListener(ioConnectFuture -> {
                if (ioConnectFuture.isCanceled()) {
                    future2.cancel(false);
                    future.cancel(true);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            block11: {
                block10: {
                    throwable2 = ExceptionUtils.peelException(throwable);
                    this.debug("connect({}) failed ({}) to schedule connection: {}", socketAddress, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
                    try {
                        if (asynchronousSocketChannel2 != null) {
                            asynchronousSocketChannel2.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!bl2) break block10;
                        this.log.debug("connect({}) - failed ({}) to close socket: {}", new Object[]{socketAddress, iOException.getClass().getSimpleName(), iOException.getMessage()});
                    }
                }
                try {
                    if (asynchronousSocketChannel != null) {
                        asynchronousSocketChannel.close();
                    }
                }
                catch (IOException iOException) {
                    if (!bl2) break block11;
                    this.log.debug("connect({}) - failed ({}) to close channel: {}", new Object[]{socketAddress, iOException.getClass().getSimpleName(), iOException.getMessage()});
                }
            }
            defaultIoConnectFuture.setException(throwable2);
        }
        return defaultIoConnectFuture;
    }

    protected AsynchronousSocketChannel openAsynchronousSocketChannel(SocketAddress socketAddress, AsynchronousChannelGroup asynchronousChannelGroup) {
        return AsynchronousSocketChannel.open(asynchronousChannelGroup);
    }

    protected Nio2CompletionHandler createConnectionCompletionHandler(IoConnectFuture ioConnectFuture, AsynchronousSocketChannel asynchronousSocketChannel, AttributeRepository attributeRepository, PropertyResolver propertyResolver, IoHandler ioHandler) {
        return new Nio2Connector$ConnectionCompletionHandler(this, ioConnectFuture, asynchronousSocketChannel, attributeRepository, propertyResolver, ioHandler);
    }

    protected Nio2Session createSession(PropertyResolver propertyResolver, IoHandler ioHandler, AsynchronousSocketChannel asynchronousSocketChannel) {
        return this.nio2ServiceFactory.createSession(this, ioHandler, asynchronousSocketChannel, null);
    }

    static /* synthetic */ Logger access$000(Nio2Connector nio2Connector) {
        return nio2Connector.log;
    }

    static /* synthetic */ Logger access$100(Nio2Connector nio2Connector) {
        return nio2Connector.log;
    }

    static /* synthetic */ Logger access$200(Nio2Connector nio2Connector) {
        return nio2Connector.log;
    }

    static /* synthetic */ Logger access$300(Nio2Connector nio2Connector) {
        return nio2Connector.log;
    }
}

