/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CancellationException;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Connector;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class Nio2Connector$ConnectionCompletionHandler
extends Nio2CompletionHandler {
    protected final IoConnectFuture future;
    protected final AsynchronousSocketChannel socket;
    protected final AttributeRepository context;
    protected final PropertyResolver propertyResolver;
    protected final IoHandler handler;
    final /* synthetic */ Nio2Connector this$0;

    protected Nio2Connector$ConnectionCompletionHandler(Nio2Connector nio2Connector, IoConnectFuture ioConnectFuture, AsynchronousSocketChannel asynchronousSocketChannel, AttributeRepository attributeRepository, PropertyResolver propertyResolver, IoHandler ioHandler) {
        this.this$0 = nio2Connector;
        this.future = ioConnectFuture;
        this.socket = asynchronousSocketChannel;
        this.context = attributeRepository;
        this.propertyResolver = propertyResolver;
        this.handler = ioHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleted(Void void_, Object object) {
        block19: {
            Long l2 = null;
            IoServiceEventListener ioServiceEventListener = this.this$0.getIoServiceEventListener();
            try {
                Object object2;
                if (ioServiceEventListener != null) {
                    object2 = this.socket.getLocalAddress();
                    SocketAddress socketAddress = this.socket.getRemoteAddress();
                    ioServiceEventListener.connectionEstablished(this.this$0, (SocketAddress)object2, this.context, socketAddress);
                }
                object2 = this.this$0.createSession(this.propertyResolver, this.handler, this.socket);
                if (this.context != null) {
                    ((Nio2Session)object2).setAttribute(AttributeRepository.class, this.context);
                }
                this.handler.sessionCreated((IoSession)object2);
                l2 = ((Nio2Session)object2).getId();
                this.this$0.sessions.put(l2, object2);
                this.future.setSession((IoSession)object2);
                if (object2 != this.future.getSession()) {
                    ((AbstractCloseable)object2).close(true);
                    throw new CancellationException();
                }
                if (((AbstractCloseable)object2).isClosing()) {
                    try {
                        this.handler.sessionClosed((IoSession)object2);
                        break block19;
                    }
                    finally {
                        this.this$0.unmapSession(l2);
                    }
                }
                ((Nio2Session)object2).startReading();
            }
            catch (CancellationException cancellationException) {
                throw cancellationException;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block21: {
                    Object object3;
                    boolean bl2;
                    block20: {
                        throwable2 = ExceptionUtils.peelException(throwable);
                        bl2 = Nio2Connector.access$000(this.this$0).isDebugEnabled();
                        if (ioServiceEventListener != null) {
                            try {
                                object3 = this.socket.getLocalAddress();
                                SocketAddress socketAddress = this.socket.getRemoteAddress();
                                ioServiceEventListener.abortEstablishedConnection(this.this$0, (SocketAddress)object3, this.context, socketAddress, throwable2);
                            }
                            catch (Exception exception) {
                                if (!bl2) break block20;
                                Nio2Connector.access$100(this.this$0).debug("onCompleted() listener=" + ioServiceEventListener + " ignoring abort event exception", (Throwable)exception);
                            }
                        }
                    }
                    Nio2Connector.access$200(this.this$0).debug("onCompleted - failed to start session: {} {}", new Object[]{throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2});
                    object3 = this.future.getSession();
                    if (object3 != null) {
                        try {
                            object3.close(true);
                        }
                        finally {
                            this.future.setException(throwable2);
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        if (!bl2) break block21;
                        Nio2Connector.access$300(this.this$0).debug("onCompleted - failed to close socket: {} {}", (Object)iOException.getClass().getSimpleName(), (Object)iOException.getMessage());
                    }
                }
                this.future.setException(throwable2);
                this.this$0.unmapSession(l2);
            }
        }
    }

    @Override
    protected void onFailed(Throwable throwable, Object object) {
        this.future.setException(throwable);
    }
}

