/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.nio2.Nio2Acceptor$1;
import org.apache.sshd.common.io.nio2.Nio2Acceptor$AcceptCompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;

public class Nio2Acceptor
extends Nio2Service
implements IoAcceptor {
    protected final Map channels = new ConcurrentHashMap();
    private final Nio2ServiceFactory nio2ServiceFactory;
    private int backlog;

    public Nio2Acceptor(Nio2ServiceFactory nio2ServiceFactory, PropertyResolver propertyResolver, IoHandler ioHandler, AsynchronousChannelGroup asynchronousChannelGroup, ExecutorService executorService) {
        super(propertyResolver, ioHandler, asynchronousChannelGroup, executorService);
        this.nio2ServiceFactory = nio2ServiceFactory;
        this.backlog = (Integer)CoreModuleProperties.SOCKET_BACKLOG.getRequired(propertyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        AsynchronousChannelGroup asynchronousChannelGroup = this.getChannelGroup();
        ArrayList<java.io.Closeable> arrayList = new ArrayList<java.io.Closeable>(collection.size());
        try {
            boolean bl2 = this.log.isDebugEnabled();
            for (SocketAddress socketAddress : collection) {
                if (bl2) {
                    this.log.debug("bind({}) binding to address", (Object)socketAddress);
                }
                try {
                    AsynchronousServerSocketChannel asynchronousServerSocketChannel;
                    AsynchronousServerSocketChannel asynchronousServerSocketChannel2 = this.openAsynchronousServerSocketChannel(socketAddress, asynchronousChannelGroup);
                    java.io.Closeable closeable = this.protectInProgressBinding(socketAddress, asynchronousServerSocketChannel2);
                    arrayList.add(closeable);
                    AsynchronousServerSocketChannel asynchronousServerSocketChannel3 = (AsynchronousServerSocketChannel)this.setSocketOptions(asynchronousServerSocketChannel2);
                    asynchronousServerSocketChannel3.bind(socketAddress, this.backlog);
                    SocketAddress socketAddress2 = asynchronousServerSocketChannel3.getLocalAddress();
                    if (bl2) {
                        this.log.debug("bind({}) bound to {}", (Object)socketAddress, (Object)socketAddress2);
                    }
                    if ((asynchronousServerSocketChannel = this.channels.put(socketAddress2, asynchronousServerSocketChannel3)) != null && bl2) {
                        this.log.debug("bind({}) replaced previous channel ({}) for {}", new Object[]{socketAddress, asynchronousServerSocketChannel.getLocalAddress(), socketAddress2});
                    }
                    CompletionHandler completionHandler = (CompletionHandler)ValidateUtils.checkNotNull((Object)this.createSocketCompletionHandler(this.channels, asynchronousServerSocketChannel3), "No completion handler created for address=%s[%s]", socketAddress, socketAddress2);
                    asynchronousServerSocketChannel3.accept(socketAddress2, completionHandler);
                }
                catch (IOException | RuntimeException exception) {
                    this.error("bind({}) - failed ({}) to bind: {}", socketAddress, exception.getClass().getSimpleName(), exception.getMessage(), exception);
                    throw exception;
                }
            }
            arrayList.clear();
        }
        finally {
            IOException iOException = IoUtils.closeQuietly(arrayList);
            if (iOException != null) {
                throw iOException;
            }
        }
    }

    protected java.io.Closeable protectInProgressBinding(SocketAddress socketAddress, AsynchronousServerSocketChannel asynchronousServerSocketChannel) {
        boolean bl2 = this.log.isDebugEnabled();
        return new Nio2Acceptor$1(this, asynchronousServerSocketChannel, bl2, socketAddress);
    }

    protected AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(SocketAddress socketAddress, AsynchronousChannelGroup asynchronousChannelGroup) {
        return AsynchronousServerSocketChannel.open(asynchronousChannelGroup);
    }

    protected CompletionHandler createSocketCompletionHandler(Map map, AsynchronousServerSocketChannel asynchronousServerSocketChannel) {
        return new Nio2Acceptor$AcceptCompletionHandler(this, asynchronousServerSocketChannel);
    }

    @Override
    public void bind(SocketAddress socketAddress) {
        this.bind(Collections.singleton(socketAddress));
    }

    @Override
    public void unbind() {
        Set set = this.getBoundAddresses();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbinding {}", (Object)set);
        }
        this.unbind(set);
    }

    @Override
    public void unbind(Collection collection) {
        boolean bl2 = this.log.isTraceEnabled();
        for (SocketAddress socketAddress : collection) {
            AsynchronousServerSocketChannel asynchronousServerSocketChannel = (AsynchronousServerSocketChannel)this.channels.remove(socketAddress);
            if (asynchronousServerSocketChannel != null) {
                try {
                    if (bl2) {
                        this.log.trace("unbind({})", (Object)socketAddress);
                    }
                    asynchronousServerSocketChannel.close();
                }
                catch (IOException iOException) {
                    this.warn("unbind({}) {} while unbinding channel: {}", socketAddress, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
                }
                continue;
            }
            if (!bl2) continue;
            this.log.trace("No active channel to unbind for {}", (Object)socketAddress);
        }
    }

    @Override
    public void unbind(SocketAddress socketAddress) {
        this.unbind(Collections.singleton(socketAddress));
    }

    @Override
    public Set getBoundAddresses() {
        return new HashSet(this.channels.keySet());
    }

    @Override
    protected void preClose() {
        this.unbind();
        super.preClose();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        Set set = this.getBoundAddresses();
        boolean bl2 = this.log.isDebugEnabled();
        for (SocketAddress socketAddress : set) {
            AsynchronousServerSocketChannel asynchronousServerSocketChannel = (AsynchronousServerSocketChannel)this.channels.remove(socketAddress);
            if (asynchronousServerSocketChannel == null) continue;
            try {
                asynchronousServerSocketChannel.close();
                if (!bl2) continue;
                this.log.debug("doCloseImmediately({}) closed channel", (Object)socketAddress);
            }
            catch (IOException iOException) {
                if (!bl2) continue;
                this.log.debug("Exception caught while closing channel of " + socketAddress, (Throwable)iOException);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBoundAddresses() + "]";
    }

    static /* synthetic */ Logger access$000(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$100(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$200(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$300(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$400(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$500(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$600(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$700(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$800(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$900(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$1000(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Nio2ServiceFactory access$1100(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.nio2ServiceFactory;
    }

    static /* synthetic */ Logger access$1200(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$1300(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$1400(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$1500(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ Logger access$1600(Nio2Acceptor nio2Acceptor) {
        return nio2Acceptor.log;
    }

    static /* synthetic */ void access$1700(Nio2Acceptor nio2Acceptor, String string, Object object, Object object2, Object object3, Throwable throwable) {
        nio2Acceptor.debug(string, object, object2, object3, throwable);
    }
}

