/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.net.SocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Objects;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.nio2.Nio2Acceptor;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2Session;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class Nio2Acceptor$AcceptCompletionHandler
extends Nio2CompletionHandler {
    protected final AsynchronousServerSocketChannel socket;
    final /* synthetic */ Nio2Acceptor this$0;

    Nio2Acceptor$AcceptCompletionHandler(Nio2Acceptor nio2Acceptor, AsynchronousServerSocketChannel asynchronousServerSocketChannel) {
        this.this$0 = nio2Acceptor;
        this.socket = asynchronousServerSocketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleted(AsynchronousSocketChannel asynchronousSocketChannel, SocketAddress socketAddress) {
        boolean bl2;
        if (!this.this$0.channels.containsKey(socketAddress)) {
            if (Nio2Acceptor.access$300(this.this$0).isDebugEnabled()) {
                Nio2Acceptor.access$400(this.this$0).debug("onCompleted({}) unbound address", (Object)socketAddress);
            }
            return;
        }
        Closeable closeable = null;
        Long l2 = null;
        IoServiceEventListener ioServiceEventListener = this.this$0.getIoServiceEventListener();
        try {
            Object object;
            if (ioServiceEventListener != null) {
                object = asynchronousSocketChannel.getLocalAddress();
                SocketAddress socketAddress2 = asynchronousSocketChannel.getRemoteAddress();
                ioServiceEventListener.connectionAccepted(this.this$0, (SocketAddress)object, socketAddress2, socketAddress);
            }
            object = this.this$0.getIoHandler();
            this.this$0.setSocketOptions(asynchronousSocketChannel);
            closeable = Objects.requireNonNull(this.createSession(this.this$0, socketAddress, asynchronousSocketChannel, (IoHandler)object), "No NIO2 session created");
            l2 = ((Nio2Session)closeable).getId();
            object.sessionCreated((IoSession)closeable);
            this.this$0.sessions.put(l2, closeable);
            if (((AbstractCloseable)closeable).isClosing()) {
                try {
                    object.sessionClosed((IoSession)closeable);
                }
                finally {
                    this.this$0.unmapSession(l2);
                }
            } else {
                ((Nio2Session)closeable).startReading();
            }
            bl2 = true;
        }
        catch (Throwable throwable) {
            block20: {
                if (ioServiceEventListener != null) {
                    try {
                        SocketAddress socketAddress3 = asynchronousSocketChannel.getLocalAddress();
                        SocketAddress socketAddress4 = asynchronousSocketChannel.getRemoteAddress();
                        ioServiceEventListener.abortAcceptedConnection(this.this$0, socketAddress3, socketAddress4, socketAddress, throwable);
                    }
                    catch (Exception exception) {
                        if (!Nio2Acceptor.access$500(this.this$0).isDebugEnabled()) break block20;
                        Nio2Acceptor.access$600(this.this$0).debug("onCompleted(" + socketAddress + ") listener=" + ioServiceEventListener + " ignoring abort event exception", (Throwable)exception);
                    }
                }
            }
            bl2 = this.okToReaccept(throwable, socketAddress);
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable throwable2) {
                    Nio2Acceptor.access$700(this.this$0).warn("onCompleted(" + socketAddress + ") Failed (" + throwable2.getClass().getSimpleName() + ") to close accepted connection from " + socketAddress + ": " + throwable2.getMessage(), throwable2);
                }
            }
            this.this$0.unmapSession(l2);
        }
        if (bl2) {
            try {
                this.socket.accept(socketAddress, this);
            }
            catch (Throwable throwable) {
                this.failed(throwable, socketAddress);
            }
        } else {
            Nio2Acceptor.access$800(this.this$0).error("=====> onCompleted({}) no longer accepting incoming connections <====", (Object)socketAddress);
        }
    }

    protected Nio2Session createSession(Nio2Acceptor nio2Acceptor, SocketAddress socketAddress, AsynchronousSocketChannel asynchronousSocketChannel, IoHandler ioHandler) {
        if (Nio2Acceptor.access$900(this.this$0).isTraceEnabled()) {
            Nio2Acceptor.access$1000(this.this$0).trace("createNio2Session({}) address={}", (Object)nio2Acceptor, (Object)socketAddress);
        }
        return Nio2Acceptor.access$1100(this.this$0).createSession(nio2Acceptor, ioHandler, asynchronousSocketChannel, socketAddress);
    }

    protected void onFailed(Throwable throwable, SocketAddress socketAddress) {
        if (this.okToReaccept(throwable, socketAddress)) {
            try {
                this.socket.accept(socketAddress, this);
            }
            catch (Throwable throwable2) {
                Nio2Acceptor.access$1200(this.this$0).error("Failed (" + throwable2.getClass().getSimpleName() + " to re-accept new connections on " + socketAddress + ": " + throwable2.getMessage(), throwable2);
            }
        }
    }

    protected boolean okToReaccept(Throwable throwable, SocketAddress socketAddress) {
        AsynchronousServerSocketChannel asynchronousServerSocketChannel = (AsynchronousServerSocketChannel)this.this$0.channels.get(socketAddress);
        boolean bl2 = Nio2Acceptor.access$1300(this.this$0).isDebugEnabled();
        if (asynchronousServerSocketChannel == null) {
            if (bl2) {
                Nio2Acceptor.access$1400(this.this$0).debug("Caught {} for untracked channel of {}: {}", new Object[]{throwable.getClass().getSimpleName(), socketAddress, throwable.getMessage()});
            }
            return false;
        }
        if (this.this$0.disposing.get()) {
            if (bl2) {
                Nio2Acceptor.access$1500(this.this$0).debug("Caught {} for tracked channel of {} while disposing: {}", new Object[]{throwable.getClass().getSimpleName(), socketAddress, throwable.getMessage()});
            }
            return false;
        }
        if (!asynchronousServerSocketChannel.isOpen()) {
            if (bl2) {
                Nio2Acceptor.access$1600(this.this$0).debug("Channel is not open ({}), stopping acceptor for {}; msg={}", new Object[]{throwable.getClass().getSimpleName(), socketAddress, throwable.getMessage()});
            }
            return false;
        }
        Nio2Acceptor.access$1700(this.this$0, "Caught {} while accepting incoming connection from {}: {}", throwable.getClass().getSimpleName(), socketAddress, throwable.getMessage(), throwable);
        return true;
    }
}

