/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.AbstractIoServiceFactoryFactory;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory$LazyDefaultIoServiceFactoryFactoryHolder;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIoServiceFactoryFactory
extends AbstractIoServiceFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactoryFactory.class);
    private IoServiceFactoryFactory factory;

    protected DefaultIoServiceFactoryFactory() {
        this((Factory)null);
    }

    protected DefaultIoServiceFactoryFactory(Factory factory) {
        super(factory);
    }

    @Override
    public IoServiceFactory create(FactoryManager factoryManager) {
        IoServiceFactoryFactory ioServiceFactoryFactory = this.getIoServiceProvider();
        return ioServiceFactoryFactory.create(factoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoServiceFactoryFactory getIoServiceProvider() {
        DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = this;
        synchronized (defaultIoServiceFactoryFactory) {
            if (this.factory != null) {
                return this.factory;
            }
            this.factory = DefaultIoServiceFactoryFactory.newInstance(IoServiceFactoryFactory.class);
            if (this.factory == null) {
                this.factory = BuiltinIoServiceFactoryFactories.NIO2.create();
                this.log.info("No detected/configured IoServiceFactoryFactory; using {}", (Object)this.factory.getClass().getSimpleName());
            } else {
                this.log.info("Using {}", (Object)this.factory.getClass().getSimpleName());
            }
            Factory factory = this.getExecutorServiceFactory();
            if (factory != null) {
                this.factory.setExecutorServiceFactory(factory);
            }
        }
        return this.factory;
    }

    public static IoServiceFactoryFactory newInstance(Class clazz) {
        IoServiceFactoryFactory ioServiceFactoryFactory;
        Object object;
        String string = clazz.getName();
        String string2 = System.getProperty(string);
        if (!GenericUtils.isEmpty(string2)) {
            return DefaultIoServiceFactoryFactory.newInstance(clazz, string2);
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader != null && (object = DefaultIoServiceFactoryFactory.tryLoad(string, ServiceLoader.load(clazz, classLoader))) != null) {
            return object;
        }
        object = DefaultIoServiceFactoryFactory.class.getClassLoader();
        if (classLoader != object && (ioServiceFactoryFactory = DefaultIoServiceFactoryFactory.tryLoad(string, ServiceLoader.load(clazz, (ClassLoader)object))) != null) {
            return ioServiceFactoryFactory;
        }
        return null;
    }

    public static IoServiceFactoryFactory tryLoad(String string, ServiceLoader serviceLoader) {
        Iterator iterator = serviceLoader.iterator();
        LinkedList<IoServiceFactoryFactory> linkedList = new LinkedList<IoServiceFactoryFactory>();
        try {
            while (iterator.hasNext()) {
                try {
                    IoServiceFactoryFactory ioServiceFactoryFactory = (IoServiceFactoryFactory)iterator.next();
                    linkedList.add(ioServiceFactoryFactory);
                }
                catch (Throwable throwable) {
                    LOGGER.warn("Exception while instantiating factory from ServiceLoader", throwable);
                }
            }
        }
        catch (Throwable throwable) {
            LOGGER.warn("Exception while loading factory from ServiceLoader", throwable);
        }
        int n2 = linkedList.size();
        if (n2 <= 0) {
            return null;
        }
        if (n2 != 1) {
            LOGGER.error("Multiple ({}) registered instances detected:", (Object)n2);
            for (IoServiceFactoryFactory ioServiceFactoryFactory : linkedList) {
                LOGGER.error("===> {}", (Object)ioServiceFactoryFactory.getClass().getName());
            }
            throw new IllegalStateException("Multiple (" + n2 + ") registered " + IoServiceFactoryFactory.class.getSimpleName() + " instances detected. Please use -D" + string + "=...factory class.. to select one or remove the extra providers from the classpath");
        }
        return (IoServiceFactoryFactory)linkedList.removeFirst();
    }

    public static IoServiceFactoryFactory newInstance(Class clazz, String string) {
        ClassLoader classLoader;
        BuiltinIoServiceFactoryFactories builtinIoServiceFactoryFactories = BuiltinIoServiceFactoryFactories.fromFactoryName(string);
        if (builtinIoServiceFactoryFactories != null) {
            IoServiceFactoryFactory ioServiceFactoryFactory = builtinIoServiceFactoryFactories.create();
            return (IoServiceFactoryFactory)clazz.cast(ioServiceFactoryFactory);
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        if (classLoader2 != null) {
            try {
                Class<?> clazz2 = classLoader2.loadClass(string);
                return (IoServiceFactoryFactory)ReflectionUtils.newInstance(clazz2, clazz);
            }
            catch (Throwable throwable) {
                LOGGER.trace("Exception while loading factory " + string, throwable);
            }
        }
        if (classLoader2 != (classLoader = DefaultIoServiceFactoryFactory.class.getClassLoader())) {
            try {
                Class<?> clazz3 = classLoader.loadClass(string);
                return (IoServiceFactoryFactory)ReflectionUtils.newInstance(clazz3, clazz);
            }
            catch (Throwable throwable) {
                LOGGER.trace("Exception while loading factory " + string, throwable);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + string);
    }

    public static DefaultIoServiceFactoryFactory getDefaultIoServiceFactoryFactoryInstance() {
        return DefaultIoServiceFactoryFactory$LazyDefaultIoServiceFactoryFactoryHolder.access$000();
    }
}

