/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.util.ReflectionUtils;

public enum BuiltinIoServiceFactoryFactories implements NamedFactory,
OptionalFeature
{
    NIO2(Nio2ServiceFactoryFactory.class),
    MINA("org.apache.sshd.common.io.mina.MinaServiceFactoryFactory"),
    NETTY("org.apache.sshd.netty.NettyIoServiceFactoryFactory");

    public static final Set VALUES;
    private final Class factoryClass;
    private final String factoryClassName;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinIoServiceFactoryFactories() {
        void var3_2;
        this.factoryClass = var3_2;
        this.factoryClassName = null;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinIoServiceFactoryFactories() {
        void var3_2;
        this.factoryClass = null;
        this.factoryClassName = var3_2;
    }

    public final String getFactoryClassName() {
        if (this.factoryClass != null) {
            return this.factoryClass.getName();
        }
        return this.factoryClassName;
    }

    public final Class getFactoryClass() {
        if (this.factoryClass != null) {
            return this.factoryClass;
        }
        try {
            return Class.forName(this.factoryClassName, true, BuiltinIoServiceFactoryFactories.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(this.factoryClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new IllegalStateException(classNotFoundException);
            }
        }
    }

    @Override
    public final String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public final IoServiceFactoryFactory create() {
        Class clazz = this.getFactoryClass();
        try {
            return (IoServiceFactoryFactory)ReflectionUtils.newInstance(clazz, IoServiceFactoryFactory.class);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    @Override
    public boolean isSupported() {
        try {
            return this.getFactoryClass() != null;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryName(String string) {
        return (BuiltinIoServiceFactoryFactories)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIoServiceFactoryFactories fromFactoryClass(Class clazz) {
        if (clazz == null || !IoServiceFactoryFactory.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIoServiceFactoryFactories builtinIoServiceFactoryFactories : VALUES) {
            if (!builtinIoServiceFactoryFactories.isSupported() || !clazz.isAssignableFrom(builtinIoServiceFactoryFactories.getFactoryClass())) continue;
            return builtinIoServiceFactoryFactories;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIoServiceFactoryFactories.class));
    }
}

