/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.FactoryManagerHolder;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractIoServiceFactory
extends AbstractCloseable
implements FactoryManagerHolder,
IoServiceFactory,
ExecutorServiceCarrier {
    private IoServiceEventListener eventListener;
    private final FactoryManager manager;
    private final CloseableExecutorService executor;

    protected AbstractIoServiceFactory(FactoryManager factoryManager, CloseableExecutorService closeableExecutorService) {
        this.manager = Objects.requireNonNull(factoryManager, "No factory manager provided");
        this.executor = Objects.requireNonNull(closeableExecutorService, "No executor service provided");
        this.eventListener = factoryManager.getIoServiceEventListener();
    }

    @Override
    public final FactoryManager getFactoryManager() {
        return this.manager;
    }

    @Override
    public final CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener ioServiceEventListener) {
        this.eventListener = ioServiceEventListener;
    }

    @Override
    protected void doCloseImmediately() {
        try {
            CloseableExecutorService closeableExecutorService = this.getExecutorService();
            if (closeableExecutorService != null && !closeableExecutorService.isShutdown()) {
                this.log.debug("Shutdown executor");
                closeableExecutorService.shutdownNow();
                if (closeableExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.debug("Shutdown complete");
                } else {
                    this.log.debug("Not all tasks terminated");
                }
            }
        }
        catch (Exception exception) {
            this.log.debug("Exception caught while closing executor", (Throwable)exception);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    protected IoService autowireCreatedService(IoService ioService) {
        if (ioService == null) {
            return ioService;
        }
        ioService.setIoServiceEventListener(this.getIoServiceEventListener());
        return ioService;
    }

    public static int getNioWorkers(FactoryManager factoryManager) {
        return (Integer)CoreModuleProperties.NIO_WORKERS.getRequired(factoryManager);
    }
}

