/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SyspropsMapWrapper;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.config.VersionProperties;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.AbstractKexFactoryManager;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import org.apache.sshd.common.session.helpers.AbstractSessionFactory;
import org.apache.sshd.common.session.helpers.SessionTimeoutListener;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.ForwardingFilter;

public abstract class AbstractFactoryManager
extends AbstractKexFactoryManager
implements FactoryManager {
    protected IoServiceFactoryFactory ioServiceFactoryFactory;
    protected IoServiceFactory ioServiceFactory;
    protected Factory randomFactory;
    protected List channelFactories;
    protected SshAgentFactory agentFactory;
    protected ScheduledExecutorService executor;
    protected boolean shutdownExecutor;
    protected ForwarderFactory forwarderFactory;
    protected ForwardingFilter forwardingFilter;
    protected FileSystemFactory fileSystemFactory;
    protected List serviceFactories;
    protected List globalRequestHandlers;
    protected SessionTimeoutListener sessionTimeoutListener;
    protected ScheduledFuture timeoutListenerFuture;
    protected final Collection sessionListeners = new CopyOnWriteArraySet();
    protected final SessionListener sessionListenerProxy;
    protected final Collection channelListeners = new CopyOnWriteArraySet();
    protected final ChannelListener channelListenerProxy;
    protected final Collection tunnelListeners = new CopyOnWriteArraySet();
    protected final PortForwardingEventListener tunnelListenerProxy;
    private final Map properties = new ConcurrentHashMap();
    private final Map attributes = new ConcurrentHashMap();
    private PropertyResolver parentResolver = SyspropsMapWrapper.SYSPROPS_RESOLVER;
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private ChannelStreamWriterResolver channelStreamWriterResolver;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private IoServiceEventListener eventListener;

    protected AbstractFactoryManager() {
        this.sessionListenerProxy = (SessionListener)EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoServiceFactory getIoServiceFactory() {
        IoServiceFactoryFactory ioServiceFactoryFactory = this.ioServiceFactoryFactory;
        synchronized (ioServiceFactoryFactory) {
            if (this.ioServiceFactory == null) {
                this.ioServiceFactory = this.ioServiceFactoryFactory.create(this);
            }
        }
        return this.ioServiceFactory;
    }

    public IoServiceFactoryFactory getIoServiceFactoryFactory() {
        return this.ioServiceFactoryFactory;
    }

    public void setIoServiceFactoryFactory(IoServiceFactoryFactory ioServiceFactoryFactory) {
        this.ioServiceFactoryFactory = ioServiceFactoryFactory;
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener ioServiceEventListener) {
        this.eventListener = ioServiceEventListener;
    }

    @Override
    public Factory getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(Factory factory) {
        this.randomFactory = factory;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public Object getAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.get(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public Collection attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public Object computeAttributeIfAbsent(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Function function) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), function);
    }

    @Override
    public Object setAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Object object) {
        return this.attributes.put(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), Objects.requireNonNull(object, "No value"));
    }

    @Override
    public Object removeAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.remove(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.parentResolver;
    }

    public void setParentPropertyResolver(PropertyResolver propertyResolver) {
        this.parentResolver = propertyResolver;
    }

    @Override
    public String getVersion() {
        String string = PropertyResolverUtils.getStringProperty(VersionProperties.getVersionProperties(), "sshd-version", "SSHD-UNKNOWN");
        return string.toUpperCase();
    }

    @Override
    public List getChannelFactories() {
        return this.channelFactories;
    }

    public void setChannelFactories(List list) {
        this.channelFactories = list;
    }

    public int getNioWorkers() {
        return (Integer)CoreModuleProperties.NIO_WORKERS.getRequired(this);
    }

    public void setNioWorkers(int n2) {
        CoreModuleProperties.NIO_WORKERS.set(this, n2);
    }

    @Override
    public SshAgentFactory getAgentFactory() {
        return this.agentFactory;
    }

    public void setAgentFactory(SshAgentFactory sshAgentFactory) {
        this.agentFactory = sshAgentFactory;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.setScheduledExecutorService(scheduledExecutorService, false);
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService, boolean bl2) {
        this.executor = scheduledExecutorService;
        this.shutdownExecutor = bl2;
    }

    @Override
    public ForwarderFactory getForwarderFactory() {
        return this.forwarderFactory;
    }

    public void setForwarderFactory(ForwarderFactory forwarderFactory) {
        this.forwarderFactory = forwarderFactory;
    }

    @Override
    public ForwardingFilter getForwardingFilter() {
        return this.forwardingFilter;
    }

    public void setForwardingFilter(ForwardingFilter forwardingFilter) {
        this.forwardingFilter = forwardingFilter;
    }

    @Override
    public FileSystemFactory getFileSystemFactory() {
        return this.fileSystemFactory;
    }

    public void setFileSystemFactory(FileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = fileSystemFactory;
    }

    @Override
    public List getServiceFactories() {
        return this.serviceFactories;
    }

    public void setServiceFactories(List list) {
        this.serviceFactories = list;
    }

    @Override
    public List getGlobalRequestHandlers() {
        return this.globalRequestHandlers;
    }

    public void setGlobalRequestHandlers(List list) {
        this.globalRequestHandlers = list;
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.reservedSessionMessagesHandler;
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler reservedSessionMessagesHandler) {
        this.reservedSessionMessagesHandler = reservedSessionMessagesHandler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return this.sessionDisconnectHandler;
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    @Override
    public ChannelStreamWriterResolver getChannelStreamWriterResolver() {
        return this.channelStreamWriterResolver;
    }

    @Override
    public void setChannelStreamWriterResolver(ChannelStreamWriterResolver channelStreamWriterResolver) {
        this.channelStreamWriterResolver = channelStreamWriterResolver;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        return this.getUnknownChannelReferenceHandler();
    }

    @Override
    public void addSessionListener(SessionListener sessionListener) {
        SessionListener.validateListener(sessionListener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while manager is closing", (Object)this, (Object)sessionListener);
            return;
        }
        if (this.sessionListeners.add(sessionListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)sessionListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)sessionListener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener sessionListener) {
        if (sessionListener == null) {
            return;
        }
        SessionListener.validateListener(sessionListener);
        if (this.sessionListeners.remove(sessionListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)sessionListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)sessionListener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        ChannelListener.validateListener(channelListener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)channelListener);
            return;
        }
        if (this.channelListeners.add(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        if (channelListener == null) {
            return;
        }
        ChannelListener.validateListener(channelListener);
        if (this.channelListeners.remove(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        PortForwardingEventListener.validateListener(portForwardingEventListener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)portForwardingEventListener);
            return;
        }
        if (this.tunnelListeners.add(portForwardingEventListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)portForwardingEventListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)portForwardingEventListener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        if (portForwardingEventListener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(portForwardingEventListener);
        if (this.tunnelListeners.remove(portForwardingEventListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)portForwardingEventListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)portForwardingEventListener);
        }
    }

    protected void setupSessionTimeout(AbstractSessionFactory abstractSessionFactory) {
        this.sessionTimeoutListener = this.createSessionTimeoutListener();
        this.addSessionListener(this.sessionTimeoutListener);
        this.timeoutListenerFuture = this.getScheduledExecutorService().scheduleAtFixedRate(this.sessionTimeoutListener, 1L, 1L, TimeUnit.SECONDS);
    }

    protected void removeSessionTimeout(AbstractSessionFactory abstractSessionFactory) {
        this.stopSessionTimeoutListener(abstractSessionFactory);
    }

    protected SessionTimeoutListener createSessionTimeoutListener() {
        return new SessionTimeoutListener();
    }

    protected void stopSessionTimeoutListener(AbstractSessionFactory abstractSessionFactory) {
        if (this.timeoutListenerFuture != null) {
            try {
                this.timeoutListenerFuture.cancel(true);
            }
            finally {
                this.timeoutListenerFuture = null;
            }
        }
        if (this.sessionTimeoutListener != null) {
            try {
                this.removeSessionListener(this.sessionTimeoutListener);
            }
            finally {
                this.sessionTimeoutListener = null;
            }
        }
    }

    protected void checkConfig() {
        ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "KeyExchangeFactories not set", new Object[0]);
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(ThreadUtils.newSingleThreadScheduledExecutor(this.toString() + "-timer"), true);
        }
        ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "CipherFactories not set", new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "CompressionFactories not set", new Object[0]);
        ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "MacFactories not set", new Object[0]);
        Objects.requireNonNull(this.getRandomFactory(), "RandomFactory not set");
        if (this.getIoServiceFactoryFactory() == null) {
            DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = DefaultIoServiceFactoryFactory.getDefaultIoServiceFactoryFactoryInstance();
            this.setIoServiceFactoryFactory(defaultIoServiceFactoryFactory);
        }
    }
}

