/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.global;

import java.security.PublicKey;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractConnectionServiceRequestHandler;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;

public abstract class AbstractOpenSshHostKeysHandler
extends AbstractConnectionServiceRequestHandler {
    private final String request;
    private final BufferPublicKeyParser parser;
    private boolean ignoreInvalidKeys;

    protected AbstractOpenSshHostKeysHandler(String string) {
        this(string, BufferPublicKeyParser.DEFAULT);
    }

    protected AbstractOpenSshHostKeysHandler(String string, BufferPublicKeyParser bufferPublicKeyParser) {
        this.request = ValidateUtils.checkNotNullAndNotEmpty(string, "No request identifier");
        this.parser = Objects.requireNonNull(bufferPublicKeyParser, "No public keys extractor");
    }

    public final String getRequestName() {
        return this.request;
    }

    public BufferPublicKeyParser getPublicKeysParser() {
        return this.parser;
    }

    @Override
    public RequestHandler$Result process(ConnectionService connectionService, String string, boolean bl2, Buffer buffer) {
        String string2 = this.getRequestName();
        if (!string2.equals(string)) {
            return super.process(connectionService, string, bl2, buffer);
        }
        LinkedList<PublicKey> linkedList = new LinkedList<PublicKey>();
        BufferPublicKeyParser bufferPublicKeyParser = this.getPublicKeysParser();
        if (bufferPublicKeyParser != null) {
            boolean bl3 = this.log.isDebugEnabled();
            while (buffer.available() > 0) {
                PublicKey publicKey;
                block7: {
                    publicKey = null;
                    try {
                        publicKey = buffer.getPublicKey(bufferPublicKeyParser);
                    }
                    catch (SshException sshException) {
                        if (!this.isIgnoreInvalidKeys()) {
                            throw sshException;
                        }
                        if (!this.log.isTraceEnabled()) break block7;
                        this.log.trace("process({})[{}] received an unsupported key", new Object[]{connectionService, string, sshException});
                    }
                }
                if (publicKey == null) continue;
                if (bl3) {
                    this.log.debug("process({})[{}] key type={}, fingerprint={}", new Object[]{connectionService, string, KeyUtils.getKeyType(publicKey), KeyUtils.getFingerPrint(publicKey)});
                }
                linkedList.add(publicKey);
            }
        }
        return this.handleHostKeys(connectionService.getSession(), linkedList, bl2, buffer);
    }

    protected void setIgnoreInvalidKeys(boolean bl2) {
        this.ignoreInvalidKeys = bl2;
    }

    protected boolean isIgnoreInvalidKeys() {
        return this.ignoreInvalidKeys;
    }

    protected abstract RequestHandler$Result handleHostKeys(Session var1, Collection var2, boolean var3, Buffer var4);

    public String toString() {
        return this.getRequestName();
    }
}

