/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CancelOption;

public interface WaitableFuture {
    public Object getId();

    default public boolean await() {
        return this.await(new CancelOption[0]);
    }

    default public boolean await(CancelOption ... cancelOptionArray) {
        return this.await(Long.MAX_VALUE, cancelOptionArray);
    }

    default public boolean await(long l2, TimeUnit timeUnit) {
        return this.await(l2, timeUnit, new CancelOption[0]);
    }

    default public boolean await(long l2, TimeUnit timeUnit, CancelOption ... cancelOptionArray) {
        return this.await(timeUnit.toMillis(l2), cancelOptionArray);
    }

    default public boolean await(Duration duration) {
        return this.await(duration, new CancelOption[0]);
    }

    default public boolean await(Duration duration, CancelOption ... cancelOptionArray) {
        return duration != null ? this.await(duration.toMillis(), cancelOptionArray) : this.await(cancelOptionArray);
    }

    default public boolean await(long l2) {
        return this.await(l2, new CancelOption[0]);
    }

    public boolean await(long var1, CancelOption ... var3);

    default public boolean awaitUninterruptibly() {
        return this.awaitUninterruptibly(new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(CancelOption ... cancelOptionArray) {
        return this.awaitUninterruptibly(Long.MAX_VALUE, cancelOptionArray);
    }

    default public boolean awaitUninterruptibly(long l2, TimeUnit timeUnit) {
        return this.awaitUninterruptibly(l2, timeUnit, new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(long l2, TimeUnit timeUnit, CancelOption ... cancelOptionArray) {
        return this.awaitUninterruptibly(timeUnit.toMillis(l2), cancelOptionArray);
    }

    default public boolean awaitUninterruptibly(Duration duration) {
        return this.awaitUninterruptibly(duration, new CancelOption[0]);
    }

    default public boolean awaitUninterruptibly(Duration duration, CancelOption ... cancelOptionArray) {
        return duration != null ? this.awaitUninterruptibly(duration.toMillis(), cancelOptionArray) : this.awaitUninterruptibly(cancelOptionArray);
    }

    default public boolean awaitUninterruptibly(long l2) {
        return this.awaitUninterruptibly(l2, new CancelOption[0]);
    }

    public boolean awaitUninterruptibly(long var1, CancelOption ... var3);

    public boolean isDone();
}

