/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.GlobalRequestFuture$ReplyHandler;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;

public class GlobalRequestFuture
extends DefaultSshFuture
implements SshFutureListener {
    private final GlobalRequestFuture$ReplyHandler handler;
    private long sequenceNumber;

    public GlobalRequestFuture(String string) {
        this(string, null);
    }

    public GlobalRequestFuture(String string, GlobalRequestFuture$ReplyHandler globalRequestFuture$ReplyHandler) {
        super(string, null);
        this.handler = globalRequestFuture$ReplyHandler;
    }

    @Override
    public String getId() {
        return (String)super.getId();
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l2) {
        if (l2 < 0L || (l2 & 0xFFFFFFFFL) != l2) {
            throw new IllegalArgumentException("Invalid sequence number " + l2);
        }
        this.sequenceNumber = l2;
    }

    public GlobalRequestFuture$ReplyHandler getHandler() {
        return this.handler;
    }

    public Buffer getBuffer() {
        Object object = this.getValue();
        if (object instanceof Buffer) {
            return (Buffer)object;
        }
        return null;
    }

    public Throwable getException() {
        Object object = this.getValue();
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }

    public void operationComplete(IoWriteFuture ioWriteFuture) {
        if (!ioWriteFuture.isWritten()) {
            Throwable throwable = ioWriteFuture.getException();
            if (throwable != null) {
                this.setValue(throwable);
            } else {
                this.setValue(new SshException("Could not write global request " + this.getId() + " seqNo=" + this.getSequenceNumber()));
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[seqNo=" + this.sequenceNumber + ']';
    }
}

