/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.InterruptedIOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.apache.sshd.common.future.AbstractSshFuture;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class DefaultSshFuture
extends AbstractSshFuture {
    private final Object lock;
    private Object listeners;
    private Object result;

    public DefaultSshFuture(Object object, Object object2) {
        super(object);
        this.lock = object2 != null ? object2 : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected Object await0(long l2, boolean bl2, CancelOption ... cancelOptionArray) {
        boolean bl3;
        long l3;
        long l4;
        long l5;
        block12: {
            ValidateUtils.checkTrue(l2 >= 0L, "Negative timeout N/A: %d", l2);
            l4 = l5 = System.currentTimeMillis();
            l3 = Long.MAX_VALUE - l2 < l4 ? Long.MAX_VALUE : l4 + l2;
            bl3 = false;
            try {
                Object object = this.lock;
                // MONITORENTER : object
                if (this.result != null) {
                    Object object2 = this.result;
                    // MONITOREXIT : object
                    if (!bl3) return object2;
                    this.notifyListeners();
                    return object2;
                }
                if (l2 > 0L) break block12;
                this.result = this.cancelOnTimeout(l2, cancelOptionArray);
                bl3 = this.result != null;
            }
            catch (Throwable throwable) {
                if (!bl3) throw throwable;
                this.notifyListeners();
                throw throwable;
            }
            Object var13_10 = null;
            // MONITOREXIT : object
            if (!bl3) return var13_10;
            this.notifyListeners();
            return var13_10;
        }
        do {
            block13: {
                try {
                    this.lock.wait(l3 - l4);
                }
                catch (InterruptedException interruptedException) {
                    if (!bl2) break block13;
                    l4 = System.currentTimeMillis();
                    InterruptedIOException interruptedIOException = (InterruptedIOException)this.formatExceptionMessage(string -> {
                        InterruptedIOException interruptedIOException = new InterruptedIOException((String)string);
                        interruptedIOException.initCause(interruptedException);
                        return interruptedIOException;
                    }, "Interrupted after %d msec.", l4 - l5);
                    if (this.result != null) throw interruptedIOException;
                    if (!Arrays.asList(cancelOptionArray).contains((Object)CancelOption.CANCEL_ON_INTERRUPT)) throw interruptedIOException;
                    CancelFuture cancelFuture = this.createCancellation();
                    if (cancelFuture == null) throw interruptedIOException;
                    CancellationException cancellationException = new CancellationException("Canceled on interrupt");
                    cancellationException.initCause(interruptedIOException);
                    cancelFuture.setBackTrace(cancellationException);
                    this.result = cancelFuture;
                    bl3 = true;
                    throw interruptedIOException;
                }
            }
            if (this.result == null) continue;
            Object object = this.result;
            // MONITOREXIT : object
            if (!bl3) return object;
            this.notifyListeners();
            return object;
        } while ((l4 = System.currentTimeMillis()) < l3);
        this.result = this.cancelOnTimeout(l2, cancelOptionArray);
        bl3 = this.result != null;
        Object var13_13 = null;
        // MONITOREXIT : object
        if (!bl3) return var13_13;
        this.notifyListeners();
        return var13_13;
    }

    private CancelFuture cancelOnTimeout(long l2, CancelOption ... cancelOptionArray) {
        CancelFuture cancelFuture;
        if (Arrays.asList(cancelOptionArray).contains((Object)CancelOption.CANCEL_ON_TIMEOUT) && (cancelFuture = this.createCancellation()) != null) {
            TimeoutException timeoutException = new TimeoutException("Timed out after " + l2 + "msec");
            CancellationException cancellationException = new CancellationException(timeoutException.getMessage());
            cancellationException.initCause(timeoutException);
            cancelFuture.setBackTrace(cancellationException);
            return cancelFuture;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.result != null) {
                return;
            }
            this.result = object != null ? object : GenericUtils.NULL;
            this.onValueSet(object);
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRegisteredListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                return 0;
            }
            if (this.listeners instanceof SshFutureListener) {
                return 1;
            }
            int n2 = Array.getLength(this.listeners);
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Array.get(this.listeners, i2) == null) continue;
                ++n3;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result == GenericUtils.NULL ? null : this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshFuture addListener(SshFutureListener sshFutureListener) {
        Objects.requireNonNull(sshFutureListener, "Missing listener argument");
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                bl2 = true;
            } else if (this.listeners == null) {
                this.listeners = sshFutureListener;
            } else if (this.listeners instanceof SshFutureListener) {
                this.listeners = new Object[]{this.listeners, sshFutureListener};
            } else {
                Object[] objectArray = (Object[])this.listeners;
                int n2 = objectArray.length;
                Object[] objectArray2 = new Object[n2 + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                objectArray2[n2] = sshFutureListener;
                this.listeners = objectArray2;
            }
        }
        if (bl2) {
            this.notifyListener(sshFutureListener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshFuture removeListener(SshFutureListener sshFutureListener) {
        Objects.requireNonNull(sshFutureListener, "No listener provided");
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return this.asT();
            }
            if (this.listeners == null) {
                return this.asT();
            }
            if (this.listeners == sshFutureListener) {
                this.listeners = null;
            } else if (!(this.listeners instanceof SshFutureListener)) {
                int n2 = Array.getLength(this.listeners);
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (Array.get(this.listeners, i2) != sshFutureListener) continue;
                    Array.set(this.listeners, i2, null);
                    break;
                }
            }
        }
        return this.asT();
    }

    protected void notifyListeners() {
        if (this.listeners != null) {
            if (this.listeners instanceof SshFutureListener) {
                this.notifyListener(this.asListener(this.listeners));
            } else {
                int n2 = Array.getLength(this.listeners);
                for (int i2 = 0; i2 < n2; ++i2) {
                    SshFutureListener sshFutureListener = this.asListener(Array.get(this.listeners, i2));
                    if (sshFutureListener == null) continue;
                    this.notifyListener(sshFutureListener);
                }
            }
        }
    }

    protected CancelFuture createCancellation() {
        return null;
    }

    protected void onValueSet(Object object) {
    }

    @Override
    public String toString() {
        return super.toString() + "[value=" + this.result + "]";
    }
}

