/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.Cancellable;
import org.apache.sshd.common.future.DefaultCancelFuture;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;

public abstract class DefaultCancellableSshFuture
extends DefaultVerifiableSshFuture
implements Cancellable {
    protected DefaultCancellableSshFuture(Object object, Object object2) {
        super(object, object2);
    }

    @Override
    public boolean isCanceled() {
        return this.getValue() instanceof CancelFuture;
    }

    @Override
    protected CancelFuture createCancellation() {
        return new DefaultCancelFuture(this.getId());
    }

    @Override
    public CancelFuture cancel() {
        CancelFuture cancelFuture = this.createCancellation();
        if (cancelFuture == null) {
            return this.getCancellation();
        }
        cancelFuture.setBackTrace(new CancellationException("Programmatically canceled"));
        this.setValue(cancelFuture);
        return this.getCancellation();
    }

    @Override
    public CancelFuture getCancellation() {
        Object object = this.getValue();
        return object instanceof CancelFuture ? (CancelFuture)object : null;
    }

    @Override
    public Throwable getException() {
        Object object = this.getValue();
        return object instanceof Throwable ? (Throwable)object : null;
    }

    @Override
    public void setException(Throwable throwable) {
        CancelFuture cancelFuture;
        this.setValue(Objects.requireNonNull(throwable, "No exception provided"));
        if (this.getException() == null && (cancelFuture = this.getCancellation()) != null) {
            cancelFuture.setCanceled(throwable);
        }
    }
}

