/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultSshFuture;

public class DefaultCancelFuture
extends DefaultSshFuture
implements CancelFuture {
    private CancellationException backTrace;

    protected DefaultCancelFuture(Object object) {
        super(object, null);
    }

    @Override
    public Boolean verify(long l2, CancelOption ... cancelOptionArray) {
        return (Boolean)this.verifyResult(Boolean.class, l2, cancelOptionArray);
    }

    @Override
    public void setCanceled() {
        this.setCanceled(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled(Throwable throwable) {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            if (this.backTrace == null) {
                this.backTrace = new CancellationException("Canceled by framework");
            }
            if (throwable != null) {
                this.backTrace.addSuppressed(throwable);
            }
        }
        this.setValue(Boolean.TRUE);
    }

    @Override
    public void setNotCanceled() {
        this.setValue(Boolean.FALSE);
    }

    @Override
    public boolean isCanceled() {
        return Boolean.TRUE.equals(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackTrace(CancellationException cancellationException) {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            if (this.backTrace == null) {
                this.backTrace = Objects.requireNonNull(cancellationException, "Cancellation backtrace must not be null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancellationException getBackTrace() {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            return this.backTrace;
        }
    }
}

