/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.InterruptedIOException;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.threads.ThreadUtils;

public abstract class AbstractSshFuture
extends AbstractLoggingBean
implements SshFuture {
    private final Object id;

    protected AbstractSshFuture(Object object) {
        this.id = object;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public boolean await(long l2, CancelOption ... cancelOptionArray) {
        return this.await0(l2, true, cancelOptionArray) != null;
    }

    @Override
    public boolean awaitUninterruptibly(long l2, CancelOption ... cancelOptionArray) {
        try {
            return this.await0(l2, false, cancelOptionArray) != null;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw (IllegalStateException)this.formatExceptionMessage(string -> new IllegalStateException((String)string, interruptedIOException), "Unexpected interrupted exception wile awaitUninterruptibly %d msec: %s", l2, interruptedIOException.getMessage());
        }
    }

    protected Object verifyResult(Class clazz, long l2, CancelOption ... cancelOptionArray) {
        Object object = this.await0(l2, true, cancelOptionArray);
        if (object == null) {
            TimeoutException timeoutException = new TimeoutException("Timed out after " + l2 + " msec");
            throw (SshException)this.formatExceptionMessage(string -> new SshException((String)string, (Throwable)timeoutException), "Failed to get operation result within specified timeout: %s msec", l2);
        }
        if (object == GenericUtils.NULL) {
            return null;
        }
        Class<Object> clazz2 = object.getClass();
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz.cast(object);
        }
        if (object instanceof CancelFuture) {
            if ((object = ((CancelFuture)object).getBackTrace()) == null) {
                object = new CancellationException("Operation was cancelled before");
            }
            clazz2 = CancellationException.class;
        }
        if (Throwable.class.isAssignableFrom(clazz2)) {
            Throwable throwable = ExceptionUtils.peelException((Throwable)object);
            if (throwable instanceof SshException) {
                throw new SshException(((SshException)throwable).getDisconnectCode(), throwable.getMessage(), throwable);
            }
            Throwable throwable2 = throwable instanceof ConnectException ? throwable : ExceptionUtils.resolveExceptionCause(throwable);
            throw (SshException)this.formatExceptionMessage(string -> new SshException((String)string, throwable2), "Failed (%s) to execute: %s", throwable.getClass().getSimpleName(), throwable.getMessage());
        }
        throw (StreamCorruptedException)this.formatExceptionMessage(StreamCorruptedException::new, "Unknown result type: %s", clazz2.getName());
    }

    protected abstract Object await0(long var1, boolean var3, CancelOption ... var4);

    protected SshFutureListener asListener(Object object) {
        return (SshFutureListener)object;
    }

    protected void notifyListener(SshFutureListener sshFutureListener) {
        try {
            SshFuture sshFuture = this.asT();
            ThreadUtils.runAsInternal(() -> {
                sshFutureListener.operationComplete(sshFuture);
                return null;
            });
        }
        catch (Throwable throwable) {
            this.warn("notifyListener({}) failed ({}) to invoke {}: {}", this, throwable.getClass().getSimpleName(), sshFutureListener, throwable.getMessage(), throwable);
        }
    }

    protected SshFuture asT() {
        return this;
    }

    protected Throwable formatExceptionMessage(Function function, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        String string3 = this.getClass().getSimpleName() + "[" + this.getId() + "]: " + string2;
        return (Throwable)function.apply(string3);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "]";
    }
}

