/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.forward.ChannelToPortHandler;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.TcpipClientChannel$1;
import org.apache.sshd.common.forward.TcpipClientChannel$Type;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipClientChannel
extends AbstractClientChannel
implements ForwardingTunnelEndpointsProvider {
    protected final SshdSocketAddress remote;
    protected final ChannelToPortHandler port;
    protected SshdSocketAddress localEntry;
    private final TcpipClientChannel$Type typeEnum;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;

    public TcpipClientChannel(TcpipClientChannel$Type tcpipClientChannel$Type, IoSession ioSession, SshdSocketAddress sshdSocketAddress) {
        super(Objects.requireNonNull(tcpipClientChannel$Type, "No type specified").getName());
        this.typeEnum = tcpipClientChannel$Type;
        this.port = this.createChannelToPortHandler(Objects.requireNonNull(ioSession, "No server session provided"));
        this.localEntry = new SshdSocketAddress((InetSocketAddress)ioSession.getLocalAddress());
        this.remote = sshdSocketAddress;
    }

    protected ChannelToPortHandler createChannelToPortHandler(IoSession ioSession) {
        return new ChannelToPortHandler(ioSession, this);
    }

    public TcpipClientChannel$Type getTcpipChannelType() {
        return this.typeEnum;
    }

    public void updateLocalForwardingEntry(LocalForwardingEntry localForwardingEntry) {
        Objects.requireNonNull(localForwardingEntry, "No local forwarding entry provided");
        this.localEntry = new SshdSocketAddress(localForwardingEntry.getLocalAddress().getHostName(), localForwardingEntry.getBoundAddress().getPort());
    }

    @Override
    public synchronized OpenFuture open() {
        SshdSocketAddress sshdSocketAddress;
        InetSocketAddress inetSocketAddress;
        IoSession ioSession = this.port.getPortSession();
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)ioSession.getLocalAddress();
        TcpipClientChannel$Type tcpipClientChannel$Type = this.getTcpipChannelType();
        switch (tcpipClientChannel$Type) {
            case Direct: {
                inetSocketAddress = (InetSocketAddress)ioSession.getRemoteAddress();
                sshdSocketAddress = this.remote;
                this.tunnelEntrance = new SshdSocketAddress(inetSocketAddress2.getHostString(), inetSocketAddress2.getPort());
                this.tunnelExit = new SshdSocketAddress(sshdSocketAddress.getHostName(), sshdSocketAddress.getPort());
                break;
            }
            case Forwarded: {
                inetSocketAddress = (InetSocketAddress)ioSession.getRemoteAddress();
                sshdSocketAddress = this.localEntry;
                this.tunnelEntrance = new SshdSocketAddress(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
                this.tunnelExit = new SshdSocketAddress(inetSocketAddress2.getHostString(), inetSocketAddress2.getPort());
                break;
            }
            default: {
                throw new SshException("Unknown client channel type: " + tcpipClientChannel$Type);
            }
        }
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(inetSocketAddress, this.futureLock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) send SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session = this.getSession();
        String string = inetSocketAddress.getHostString();
        String string2 = sshdSocketAddress.getHostName();
        LocalWindow localWindow = this.getLocalWindow();
        String string3 = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, string3.length() + string.length() + string2.length() + 64);
        buffer.putString(string3);
        buffer.putUInt(this.getChannelId());
        buffer.putUInt(localWindow.getSize());
        buffer.putUInt(localWindow.getPacketSize());
        buffer.putString(string2);
        buffer.putUInt(sshdSocketAddress.getPort());
        buffer.putString(string);
        buffer.putUInt(inetSocketAddress.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() {
        if (this.streaming == StreamingChannel$Streaming.Async) {
            this.asyncIn = new TcpipClientChannel$1(this, this, 94);
            this.asyncOut = new ChannelAsyncInputStream(this);
        } else {
            this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.port.getPortSession(), super.getInnerCloseable()).build();
    }

    @Override
    protected void doWriteData(byte[] byArray, int n2, long l2) {
        this.port.sendToPort((byte)94, byArray, n2, l2);
    }

    @Override
    protected void doWriteExtendedData(byte[] byArray, int n2, long l2) {
        throw new UnsupportedOperationException(this.getChannelType() + " Tcpip channel does not support extended data");
    }

    @Override
    public void handleEof() {
        super.handleEof();
        this.port.handleEof();
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    static /* synthetic */ IoWriteFuture access$000(TcpipClientChannel tcpipClientChannel) {
        return tcpipClientChannel.sendEof();
    }
}

