/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.forward.SocksProxy$Proxy;
import org.apache.sshd.common.forward.SocksProxy$Socks4;
import org.apache.sshd.common.forward.SocksProxy$Socks5;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.slf4j.Logger;

public class SocksProxy
extends AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map proxies = new ConcurrentHashMap();

    public SocksProxy(ConnectionService connectionService) {
        this.service = connectionService;
    }

    @Override
    public void sessionCreated(IoSession ioSession) {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed: " + this.state);
        }
    }

    @Override
    public void sessionClosed(IoSession ioSession) {
        SocksProxy$Proxy socksProxy$Proxy = (SocksProxy$Proxy)this.proxies.remove(ioSession);
        if (socksProxy$Proxy != null) {
            socksProxy$Proxy.close();
        }
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable readable) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(readable.available() + 64, false);
        byteArrayBuffer.putBuffer(readable);
        SocksProxy$Proxy socksProxy$Proxy = (SocksProxy$Proxy)this.proxies.get(ioSession);
        if (socksProxy$Proxy == null) {
            int n2 = byteArrayBuffer.getUByte();
            if (n2 == 4) {
                socksProxy$Proxy = new SocksProxy$Socks4(this, ioSession);
            } else if (n2 == 5) {
                socksProxy$Proxy = new SocksProxy$Socks5(this, ioSession);
            } else {
                throw new IllegalStateException("Unsupported version: " + n2);
            }
            socksProxy$Proxy.onMessage(byteArrayBuffer);
            this.proxies.put(ioSession, socksProxy$Proxy);
        } else {
            socksProxy$Proxy.onMessage(byteArrayBuffer);
        }
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        this.log.warn("Exception caught, closing socks proxy", throwable);
        ioSession.close(false);
    }

    static /* synthetic */ Logger access$000(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$100(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ ConnectionService access$200(SocksProxy socksProxy) {
        return socksProxy.service;
    }

    static /* synthetic */ Logger access$300(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$400(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$500(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$600(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$700(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$800(SocksProxy socksProxy) {
        return socksProxy.log;
    }

    static /* synthetic */ Logger access$900(SocksProxy socksProxy) {
        return socksProxy.log;
    }
}

