/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.forward.SocksProxy$Proxy;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipClientChannel$Type;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SocksProxy$Socks5
extends SocksProxy$Proxy {
    private byte[] authMethods;
    private Buffer response;
    final /* synthetic */ SocksProxy this$0;

    public SocksProxy$Socks5(SocksProxy socksProxy, IoSession ioSession) {
        this.this$0 = socksProxy;
        super(ioSession);
    }

    @Override
    protected void onMessage(Buffer buffer) {
        boolean bl2 = SocksProxy.access$400(this.this$0).isDebugEnabled();
        if (this.authMethods == null) {
            int n2 = this.getUByte(buffer);
            this.authMethods = new byte[n2];
            buffer.getRawBytes(this.authMethods);
            boolean bl3 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                bl3 |= this.authMethods[i2] == 0;
            }
            buffer = new ByteArrayBuffer(8, false);
            buffer.putByte((byte)5);
            buffer.putByte((byte)(bl3 ? 0 : 255));
            this.session.writeBuffer(buffer);
            if (!bl3) {
                throw new IllegalStateException("Received socks5 greeting without NoAuth method");
            }
            if (bl2) {
                SocksProxy.access$500(this.this$0).debug("Received socks5 greeting");
            }
        } else if (this.channel == null) {
            String string;
            int n3;
            this.response = buffer;
            int n4 = this.getUByte(buffer);
            if (n4 != 5) {
                throw new IllegalStateException("Unexpected version: " + n4);
            }
            int n5 = buffer.getUByte();
            if (n5 != 1) {
                throw new IllegalStateException("Unsupported socks command: " + n5);
            }
            int n6 = buffer.getUByte();
            if (n6 != 0 && bl2) {
                SocksProxy.access$600(this.this$0).debug("No zero reserved value: {}", (Object)n6);
            }
            if ((n3 = buffer.getUByte()) == 1) {
                string = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
            } else if (n3 == 3) {
                string = this.getBLString(buffer);
            } else if (n3 == 4) {
                string = Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer));
            } else {
                throw new IllegalStateException("Unsupported address type: " + n3);
            }
            int n7 = this.getUShort(buffer);
            if (bl2) {
                SocksProxy.access$700(this.this$0).debug("Received socks5 connection request to {}:{}", (Object)string, (Object)n7);
            }
            SshdSocketAddress sshdSocketAddress = new SshdSocketAddress(string, n7);
            this.channel = new TcpipClientChannel(TcpipClientChannel$Type.Direct, this.session, sshdSocketAddress);
            this.channel.setStreaming(StreamingChannel$Streaming.Async);
            this.session.suspendRead();
            SocksProxy.access$200(this.this$0).registerChannel(this.channel);
            this.channel.open().addListener(this::onChannelOpened);
        } else {
            if (bl2) {
                SocksProxy.access$800(this.this$0).debug("Received socks5 connection message");
            }
            super.onMessage(buffer);
        }
    }

    protected void onChannelOpened(OpenFuture openFuture) {
        this.session.resumeRead();
        int n2 = this.response.wpos();
        this.response.rpos(0);
        this.response.wpos(1);
        Throwable throwable = openFuture.getException();
        if (throwable != null) {
            SocksProxy.access$200(this.this$0).unregisterChannel(this.channel);
            this.channel.close(true);
            this.response.putByte((byte)1);
        } else {
            this.response.putByte((byte)0);
        }
        this.response.wpos(n2);
        try {
            this.session.writeBuffer(this.response);
        }
        catch (IOException iOException) {
            SocksProxy.access$900(this.this$0).error("Failed ({}) to send channel open response for {}: {}", new Object[]{iOException.getClass().getSimpleName(), this.channel, iOException.getMessage()});
            throw new IllegalStateException("Failed to send packet", iOException);
        }
    }

    protected String getBLString(Buffer buffer) {
        int n2 = this.getUByte(buffer);
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append((char)this.getUByte(buffer));
        }
        return stringBuilder.toString();
    }
}

