/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class LocalForwardingEntry {
    private final SshdSocketAddress local;
    private final SshdSocketAddress bound;
    private final SshdSocketAddress combined;

    public LocalForwardingEntry(SshdSocketAddress sshdSocketAddress, InetSocketAddress inetSocketAddress) {
        this(sshdSocketAddress, new SshdSocketAddress(inetSocketAddress));
    }

    public LocalForwardingEntry(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        this.local = Objects.requireNonNull(sshdSocketAddress, "No local address provided");
        this.bound = Objects.requireNonNull(sshdSocketAddress2, "No bound address provided");
        this.combined = LocalForwardingEntry.resolveCombinedBoundAddress(sshdSocketAddress, sshdSocketAddress2);
    }

    public SshdSocketAddress getLocalAddress() {
        return this.local;
    }

    public SshdSocketAddress getBoundAddress() {
        return this.bound;
    }

    public SshdSocketAddress getCombinedBoundAddress() {
        return this.combined;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LocalForwardingEntry localForwardingEntry = (LocalForwardingEntry)object;
        return Objects.equals(this.getCombinedBoundAddress(), localForwardingEntry.getCombinedBoundAddress());
    }

    public int hashCode() {
        return Objects.hashCode(this.getCombinedBoundAddress());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", bound=" + this.getBoundAddress() + ", combined=" + this.getCombinedBoundAddress() + "]";
    }

    public static SshdSocketAddress resolveCombinedBoundAddress(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        int n2 = sshdSocketAddress.getPort();
        int n3 = sshdSocketAddress2.getPort();
        if (n2 > 0 && n2 != n3) {
            throw new IllegalArgumentException("Mismatched ports for local (" + sshdSocketAddress + ") vs. bound (" + sshdSocketAddress2 + ") entry");
        }
        if (Objects.equals(sshdSocketAddress, sshdSocketAddress2)) {
            return sshdSocketAddress;
        }
        String string = sshdSocketAddress.getHostName();
        boolean bl2 = SshdSocketAddress.isWildcardAddress(string);
        if (bl2) {
            return sshdSocketAddress2;
        }
        if (n2 > 0) {
            return sshdSocketAddress;
        }
        return new SshdSocketAddress(string, n3);
    }

    public static LocalForwardingEntry findMatchingEntry(String string, int n2, Collection collection) {
        return LocalForwardingEntry.findMatchingEntry(string, SshdSocketAddress.isWildcardAddress(string), n2, collection);
    }

    public static LocalForwardingEntry findMatchingEntry(String string, boolean bl2, int n2, Collection collection) {
        if (n2 <= 0 || GenericUtils.isEmpty(collection)) {
            return null;
        }
        if (GenericUtils.isEmpty(string) && !bl2) {
            return null;
        }
        LocalForwardingEntry localForwardingEntry = null;
        for (LocalForwardingEntry localForwardingEntry2 : collection) {
            SshdSocketAddress sshdSocketAddress = localForwardingEntry2.getBoundAddress();
            if (n2 != sshdSocketAddress.getPort()) continue;
            String string2 = sshdSocketAddress.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(string, string2, false)) {
                return localForwardingEntry2;
            }
            SshdSocketAddress sshdSocketAddress2 = localForwardingEntry2.getLocalAddress();
            String string3 = sshdSocketAddress2.getHostName();
            if (SshdSocketAddress.isEquivalentHostName(string, string3, false)) {
                return localForwardingEntry2;
            }
            if (SshdSocketAddress.isLoopbackAlias(string, string2) || SshdSocketAddress.isLoopbackAlias(string, string3)) {
                return localForwardingEntry2;
            }
            if (!bl2) continue;
            if (localForwardingEntry != null) {
                throw new IllegalStateException("Multiple candidate matches for " + string + "@" + n2 + ": " + localForwardingEntry + ", " + localForwardingEntry2);
            }
            localForwardingEntry = localForwardingEntry2;
        }
        if (bl2) {
            return localForwardingEntry;
        }
        return null;
    }
}

