/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.forward.DefaultForwarder$StaticIoHandler;
import org.apache.sshd.common.forward.Forwarder;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManagerHolder;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoHandlerFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.io.functors.Invoker;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.slf4j.Logger;

public class DefaultForwarder
extends AbstractInnerCloseable
implements Forwarder,
PortForwardingEventListenerManager,
SessionHolder {
    public static final Set STATIC_IO_MSG_RECEIVED_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.OPENED, ClientChannelEvent.CLOSED));
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = () -> new SocksProxy(this.getConnectionService());
    private final Session sessionInstance;
    private final Object localLock = new Object();
    private final Map localToRemote = new HashMap();
    private final Map boundLocals = new HashMap();
    private final Object dynamicLock = new Object();
    private final Map remoteToLocal = new HashMap();
    private final Map dynamicLocal = new HashMap();
    private final Map boundDynamic = new HashMap();
    private final Set localForwards = new HashSet();
    private final IoHandlerFactory staticIoHandlerFactory = () -> new DefaultForwarder$StaticIoHandler(this);
    private final Collection listeners = new CopyOnWriteArraySet();
    private final Collection managersHolder = new CopyOnWriteArraySet();
    private final PortForwardingEventListener listenerProxy;
    private IoAcceptor localAcceptor;
    private IoAcceptor dynamicAcceptor;

    public DefaultForwarder(ConnectionService connectionService) {
        this.service = Objects.requireNonNull(connectionService, "No connection service");
        this.sessionInstance = Objects.requireNonNull(connectionService.getSession(), "No session");
        this.listenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.listeners);
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        this.listeners.add(PortForwardingEventListener.validateListener(portForwardingEventListener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener portForwardingEventListener) {
        if (portForwardingEventListener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(portForwardingEventListener));
    }

    @Override
    public Collection getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager portForwardingEventListenerManager) {
        return this.managersHolder.add(Objects.requireNonNull(portForwardingEventListenerManager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager portForwardingEventListenerManager) {
        if (portForwardingEventListenerManager == null) {
            return false;
        }
        return this.managersHolder.remove(portForwardingEventListenerManager);
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    protected Collection getDefaultListeners() {
        ArrayList<PortForwardingEventListener> arrayList = new ArrayList<PortForwardingEventListener>();
        arrayList.add(this.getPortForwardingEventListenerProxy());
        Session session = this.getSession();
        PortForwardingEventListener portForwardingEventListener = session.getPortForwardingEventListenerProxy();
        if (portForwardingEventListener != null) {
            arrayList.add(portForwardingEventListener);
        }
        FactoryManager factoryManager = session == null ? null : session.getFactoryManager();
        PortForwardingEventListener portForwardingEventListener2 = portForwardingEventListener = factoryManager == null ? null : factoryManager.getPortForwardingEventListenerProxy();
        if (portForwardingEventListener != null) {
            arrayList.add(portForwardingEventListener);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        SshdSocketAddress sshdSocketAddress3;
        Objects.requireNonNull(sshdSocketAddress, "Local address is null");
        ValidateUtils.checkTrue(sshdSocketAddress.getPort() >= 0, "Invalid local port: %s", (Object)sshdSocketAddress);
        Objects.requireNonNull(sshdSocketAddress2, "Remote address is null");
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closed or closing: " + this.state);
        }
        this.signalEstablishingExplicitTunnel(sshdSocketAddress, sshdSocketAddress2, true);
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = this.doBind(sshdSocketAddress, this.getLocalIoAcceptor());
            int n2 = inetSocketAddress.getPort();
            sshdSocketAddress3 = new SshdSocketAddress(inetSocketAddress.getHostString(), n2);
            Object object = this.localLock;
            synchronized (object) {
                SshdSocketAddress sshdSocketAddress4 = (SshdSocketAddress)SshdSocketAddress.findByOptionalWildcardAddress(this.localToRemote, sshdSocketAddress3);
                if (sshdSocketAddress4 != null) {
                    throw new IOException("Multiple local port forwarding addressing on port=" + sshdSocketAddress3 + ": current=" + sshdSocketAddress2 + ", previous=" + sshdSocketAddress4);
                }
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)SshdSocketAddress.findByOptionalWildcardAddress(this.boundLocals, sshdSocketAddress3);
                if (inetSocketAddress2 != null) {
                    throw new IOException("Multiple local port forwarding bindings on port=" + sshdSocketAddress3 + ": current=" + inetSocketAddress + ", previous=" + inetSocketAddress2);
                }
                this.localToRemote.put(sshdSocketAddress3, sshdSocketAddress2);
                this.boundLocals.put(sshdSocketAddress3, inetSocketAddress);
            }
        }
        catch (IOException | RuntimeException exception) {
            try {
                this.unbindLocalForwarding(sshdSocketAddress, sshdSocketAddress2, inetSocketAddress);
            }
            catch (IOException | RuntimeException exception2) {
                exception.addSuppressed(exception2);
            }
            this.signalEstablishedExplicitTunnel(sshdSocketAddress, sshdSocketAddress2, true, null, exception);
            throw exception;
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("startLocalPortForwarding({} -> {}): {}", new Object[]{sshdSocketAddress, sshdSocketAddress2, sshdSocketAddress3});
            }
            this.signalEstablishedExplicitTunnel(sshdSocketAddress, sshdSocketAddress2, true, sshdSocketAddress3, null);
            return sshdSocketAddress3;
        }
        catch (IOException | RuntimeException exception) {
            this.stopLocalPortForwarding(sshdSocketAddress);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress sshdSocketAddress) {
        InetSocketAddress inetSocketAddress;
        SshdSocketAddress sshdSocketAddress2;
        Objects.requireNonNull(sshdSocketAddress, "Local address is null");
        Object object = this.localLock;
        synchronized (object) {
            sshdSocketAddress2 = (SshdSocketAddress)SshdSocketAddress.removeByOptionalWildcardAddress(this.localToRemote, sshdSocketAddress);
            inetSocketAddress = (InetSocketAddress)SshdSocketAddress.removeByOptionalWildcardAddress(this.boundLocals, sshdSocketAddress);
        }
        this.unbindLocalForwarding(sshdSocketAddress, sshdSocketAddress2, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindLocalForwarding(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("unbindLocalForwarding({} => {}) unbind {}", new Object[]{sshdSocketAddress, sshdSocketAddress2, inetSocketAddress});
            }
            SshdSocketAddress sshdSocketAddress3 = new SshdSocketAddress(inetSocketAddress);
            try {
                this.signalTearingDownExplicitTunnel(sshdSocketAddress3, true, sshdSocketAddress2);
            }
            finally {
                try {
                    this.localAcceptor.unbind(inetSocketAddress);
                }
                catch (RuntimeException runtimeException) {
                    this.signalTornDownExplicitTunnel(sshdSocketAddress3, true, sshdSocketAddress2, runtimeException);
                    throw runtimeException;
                }
            }
            this.signalTornDownExplicitTunnel(sshdSocketAddress3, true, sshdSocketAddress2, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("unbindLocalForwarding({} => {}) no mapping({}) or acceptor({})", new Object[]{sshdSocketAddress, sshdSocketAddress2, inetSocketAddress, this.localAcceptor});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2) {
        Object object;
        int n2;
        Objects.requireNonNull(sshdSocketAddress2, "Local address is null");
        Objects.requireNonNull(sshdSocketAddress, "Remote address is null");
        String string = sshdSocketAddress.getHostName();
        int n3 = sshdSocketAddress.getPort();
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)80, string.length() + 64);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(string);
        buffer.putUInt(n3);
        Duration duration = (Duration)CoreModuleProperties.FORWARD_REQUEST_TIMEOUT.getRequired(session);
        this.signalEstablishingExplicitTunnel(sshdSocketAddress2, sshdSocketAddress, false);
        try {
            Buffer buffer2 = session.request("tcpip-forward", buffer, duration);
            if (buffer2 == null) {
                throw new SshException("Tcpip forwarding request denied by server");
            }
            n2 = n3 == 0 ? buffer2.getInt() : sshdSocketAddress.getPort();
            object = this.remoteToLocal;
            synchronized (object) {
                SshdSocketAddress sshdSocketAddress3 = (SshdSocketAddress)this.remoteToLocal.get(n2);
                if (sshdSocketAddress3 != null) {
                    throw new IOException("Multiple remote port forwarding bindings on port=" + n2 + ": current=" + sshdSocketAddress + ", previous=" + sshdSocketAddress3);
                }
                this.remoteToLocal.put(n2, sshdSocketAddress2);
            }
        }
        catch (IOException | RuntimeException exception) {
            try {
                this.stopRemotePortForwarding(sshdSocketAddress);
            }
            catch (IOException | RuntimeException exception2) {
                exception.addSuppressed(exception2);
            }
            this.signalEstablishedExplicitTunnel(sshdSocketAddress2, sshdSocketAddress, false, null, exception);
            throw exception;
        }
        try {
            object = new SshdSocketAddress(string, n2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startRemotePortForwarding({} -> {}): {}", new Object[]{sshdSocketAddress, sshdSocketAddress2, object});
            }
            this.signalEstablishedExplicitTunnel(sshdSocketAddress2, sshdSocketAddress, false, (SshdSocketAddress)object, null);
            return object;
        }
        catch (IOException | RuntimeException exception) {
            this.stopRemotePortForwarding(sshdSocketAddress);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress sshdSocketAddress) {
        SshdSocketAddress sshdSocketAddress2;
        int n2 = sshdSocketAddress.getPort();
        Object object = this.remoteToLocal;
        synchronized (object) {
            sshdSocketAddress2 = (SshdSocketAddress)this.remoteToLocal.remove(n2);
        }
        if (sshdSocketAddress2 != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding({}) cancel forwarding to {}", (Object)sshdSocketAddress, (Object)sshdSocketAddress2);
            }
            object = sshdSocketAddress.getHostName();
            Session session = this.getSession();
            Buffer buffer = session.createBuffer((byte)80, ((String)object).length() + 64);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString((String)object);
            buffer.putUInt(n2);
            this.signalTearingDownExplicitTunnel(sshdSocketAddress2, false, sshdSocketAddress);
            try {
                session.writePacket(buffer);
            }
            catch (IOException | RuntimeException exception) {
                this.signalTornDownExplicitTunnel(sshdSocketAddress2, false, sshdSocketAddress, exception);
                throw exception;
            }
            this.signalTornDownExplicitTunnel(sshdSocketAddress2, false, sshdSocketAddress, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding({}) no binding found", (Object)sshdSocketAddress);
        }
    }

    protected void signalTearingDownExplicitTunnel(SshdSocketAddress sshdSocketAddress, boolean bl2, SshdSocketAddress sshdSocketAddress2) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalTearingDownExplicitTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, bl2, sshdSocketAddress2);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IOException("Failed (" + throwable.getClass().getSimpleName() + ") to signal tearing down explicit tunnel for local=" + bl2 + " on bound=" + sshdSocketAddress, throwable);
        }
    }

    protected void signalTearingDownExplicitTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, boolean bl2, SshdSocketAddress sshdSocketAddress2) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.tearingDownExplicitTunnel(this.getSession(), sshdSocketAddress, bl2, sshdSocketAddress2);
    }

    protected void signalTornDownExplicitTunnel(SshdSocketAddress sshdSocketAddress, boolean bl2, SshdSocketAddress sshdSocketAddress2, Throwable throwable) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalTornDownExplicitTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, bl2, sshdSocketAddress2, throwable);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable2) {
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw new IOException("Failed (" + throwable3.getClass().getSimpleName() + ") to signal torn down explicit tunnel local=" + bl2 + " on bound=" + sshdSocketAddress, throwable3);
        }
    }

    protected void signalTornDownExplicitTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, boolean bl2, SshdSocketAddress sshdSocketAddress2, Throwable throwable) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.tornDownExplicitTunnel(this.getSession(), sshdSocketAddress, bl2, sshdSocketAddress2, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress sshdSocketAddress) {
        Object object;
        int n2;
        Objects.requireNonNull(sshdSocketAddress, "Local address is null");
        ValidateUtils.checkTrue(sshdSocketAddress.getPort() >= 0, "Invalid local port: %s", (Object)sshdSocketAddress);
        if (this.isClosed() || this.isClosing()) {
            throw new IllegalStateException("DefaultForwarder is closed or closing: " + this.state);
        }
        SocksProxy socksProxy = null;
        InetSocketAddress inetSocketAddress = null;
        this.signalEstablishingDynamicTunnel(sshdSocketAddress);
        try {
            inetSocketAddress = this.doBind(sshdSocketAddress, this.getDynamicIoAcceptor());
            n2 = inetSocketAddress.getPort();
            object = this.dynamicLock;
            synchronized (object) {
                SocksProxy socksProxy2 = (SocksProxy)this.dynamicLocal.get(n2);
                if (socksProxy2 != null) {
                    throw new IOException("Multiple dynamic port mappings found for port=" + n2 + ": current=" + socksProxy + ", previous=" + socksProxy2);
                }
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)this.boundDynamic.get(n2);
                if (inetSocketAddress2 != null) {
                    throw new IOException("Multiple dynamic port bindings found for port=" + n2 + ": current=" + inetSocketAddress + ", previous=" + inetSocketAddress2);
                }
                socksProxy = new SocksProxy(this.service);
                this.dynamicLocal.put(n2, socksProxy);
                this.boundDynamic.put(n2, inetSocketAddress);
            }
        }
        catch (IOException | RuntimeException exception) {
            try {
                this.unbindDynamicForwarding(sshdSocketAddress, socksProxy, inetSocketAddress);
            }
            catch (IOException | RuntimeException exception2) {
                exception.addSuppressed(exception2);
            }
            this.signalEstablishedDynamicTunnel(sshdSocketAddress, null, exception);
            throw exception;
        }
        try {
            object = new SshdSocketAddress(inetSocketAddress.getHostString(), n2);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startDynamicPortForwarding({}): {}", (Object)sshdSocketAddress, object);
            }
            this.signalEstablishedDynamicTunnel(sshdSocketAddress, (SshdSocketAddress)object, null);
            return object;
        }
        catch (IOException | RuntimeException exception) {
            this.stopDynamicPortForwarding(sshdSocketAddress);
            throw exception;
        }
    }

    protected void signalEstablishedDynamicTunnel(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, Throwable throwable) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalEstablishedDynamicTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, sshdSocketAddress2, throwable);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable2) {
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw new IOException("Failed (" + throwable3.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + sshdSocketAddress + " on bound=" + sshdSocketAddress2, throwable3);
        }
    }

    protected void signalEstablishedDynamicTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, Throwable throwable) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.establishedDynamicTunnel(this.getSession(), sshdSocketAddress, sshdSocketAddress2, throwable);
    }

    protected void signalEstablishingDynamicTunnel(SshdSocketAddress sshdSocketAddress) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalEstablishingDynamicTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IOException("Failed (" + throwable.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + sshdSocketAddress, throwable);
        }
    }

    protected void signalEstablishingDynamicTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.establishingDynamicTunnel(this.getSession(), sshdSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress sshdSocketAddress) {
        InetSocketAddress inetSocketAddress;
        SocksProxy socksProxy;
        int n2 = sshdSocketAddress.getPort();
        Object object = this.dynamicLock;
        synchronized (object) {
            socksProxy = (SocksProxy)this.dynamicLocal.remove(n2);
            inetSocketAddress = (InetSocketAddress)this.boundDynamic.remove(n2);
        }
        this.unbindDynamicForwarding(sshdSocketAddress, socksProxy, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unbindDynamicForwarding(SshdSocketAddress sshdSocketAddress, SocksProxy socksProxy, InetSocketAddress inetSocketAddress) {
        block24: {
            boolean bl2 = this.log.isDebugEnabled();
            if (inetSocketAddress == null && socksProxy == null) {
                if (!bl2) return;
                this.log.debug("stopDynamicPortForwarding({}) no binding found", (Object)sshdSocketAddress);
                return;
            }
            try {
                this.signalTearingDownDynamicTunnel(sshdSocketAddress);
            }
            catch (Throwable throwable) {
                try {
                    block20: {
                        block21: {
                            try {
                                if (socksProxy != null) {
                                    if (bl2) {
                                        this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)sshdSocketAddress, (Object)socksProxy);
                                    }
                                    socksProxy.close(true);
                                }
                                if (inetSocketAddress == null || this.dynamicAcceptor == null) break block20;
                                if (!bl2) break block21;
                            }
                            catch (Throwable throwable2) {
                                if (inetSocketAddress != null && this.dynamicAcceptor != null) {
                                    if (bl2) {
                                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)sshdSocketAddress, (Object)inetSocketAddress);
                                    }
                                    this.dynamicAcceptor.unbind(inetSocketAddress);
                                    throw throwable2;
                                }
                                if (!bl2) throw throwable2;
                                this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{sshdSocketAddress, this.dynamicAcceptor, inetSocketAddress});
                                throw throwable2;
                            }
                            this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)sshdSocketAddress, (Object)inetSocketAddress);
                        }
                        this.dynamicAcceptor.unbind(inetSocketAddress);
                        throw throwable;
                    }
                    if (!bl2) throw throwable;
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{sshdSocketAddress, this.dynamicAcceptor, inetSocketAddress});
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.signalTornDownDynamicTunnel(sshdSocketAddress, runtimeException);
                    throw runtimeException;
                }
            }
            try {
                block22: {
                    block23: {
                        try {
                            if (socksProxy != null) {
                                if (bl2) {
                                    this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)sshdSocketAddress, (Object)socksProxy);
                                }
                                socksProxy.close(true);
                            }
                            if (inetSocketAddress == null || this.dynamicAcceptor == null) break block22;
                            if (!bl2) break block23;
                        }
                        catch (Throwable throwable) {
                            if (inetSocketAddress != null && this.dynamicAcceptor != null) {
                                if (bl2) {
                                    this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)sshdSocketAddress, (Object)inetSocketAddress);
                                }
                                this.dynamicAcceptor.unbind(inetSocketAddress);
                                throw throwable;
                            }
                            if (!bl2) throw throwable;
                            this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{sshdSocketAddress, this.dynamicAcceptor, inetSocketAddress});
                            throw throwable;
                        }
                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)sshdSocketAddress, (Object)inetSocketAddress);
                    }
                    this.dynamicAcceptor.unbind(inetSocketAddress);
                    break block24;
                }
                if (bl2) {
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{sshdSocketAddress, this.dynamicAcceptor, inetSocketAddress});
                }
            }
            catch (RuntimeException runtimeException) {
                this.signalTornDownDynamicTunnel(sshdSocketAddress, runtimeException);
                throw runtimeException;
            }
        }
        this.signalTornDownDynamicTunnel(sshdSocketAddress, null);
    }

    protected void signalTearingDownDynamicTunnel(SshdSocketAddress sshdSocketAddress) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalTearingDownDynamicTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IOException("Failed (" + throwable.getClass().getSimpleName() + ") to signal tearing down dynamic tunnel for address=" + sshdSocketAddress, throwable);
        }
    }

    protected void signalTearingDownDynamicTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.tearingDownDynamicTunnel(this.getSession(), sshdSocketAddress);
    }

    protected void signalTornDownDynamicTunnel(SshdSocketAddress sshdSocketAddress, Throwable throwable) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalTornDownDynamicTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, throwable);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable2) {
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw new IOException("Failed (" + throwable3.getClass().getSimpleName() + ") to signal torn down dynamic tunnel for address=" + sshdSocketAddress, throwable3);
        }
    }

    protected void signalTornDownDynamicTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, Throwable throwable) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.tornDownDynamicTunnel(this.getSession(), sshdSocketAddress, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int n2) {
        Map map = this.remoteToLocal;
        synchronized (map) {
            return (SshdSocketAddress)this.remoteToLocal.get(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress sshdSocketAddress) {
        SshdSocketAddress sshdSocketAddress2;
        Objects.requireNonNull(sshdSocketAddress, "Local address is null");
        ValidateUtils.checkTrue(sshdSocketAddress.getPort() >= 0, "Invalid local port: %s", (Object)sshdSocketAddress);
        Session session = this.getSession();
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        TcpForwardingFilter tcpForwardingFilter = factoryManager.getTcpForwardingFilter();
        try {
            if (tcpForwardingFilter == null || !tcpForwardingFilter.canListen(sshdSocketAddress, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("localPortForwardingRequested({})[{}][haveFilter={}] rejected", new Object[]{session, sshdSocketAddress, tcpForwardingFilter != null});
                }
                return null;
            }
        }
        catch (Error error) {
            this.warn("localPortForwardingRequested({})[{}] failed ({}) to consult forwarding filter: {}", session, sshdSocketAddress, error.getClass().getSimpleName(), error.getMessage(), error);
            throw new RuntimeSshException(error);
        }
        this.signalEstablishingExplicitTunnel(sshdSocketAddress, null, true);
        try {
            boolean bl2;
            InetSocketAddress inetSocketAddress = this.doBind(sshdSocketAddress, this.getLocalIoAcceptor());
            sshdSocketAddress2 = new SshdSocketAddress(inetSocketAddress);
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested({}): {}", (Object)sshdSocketAddress, (Object)sshdSocketAddress2);
            }
            LocalForwardingEntry localForwardingEntry = new LocalForwardingEntry(sshdSocketAddress, sshdSocketAddress2);
            Set set = this.localForwards;
            synchronized (set) {
                bl2 = this.localForwards.add(localForwardingEntry);
            }
            if (!bl2) {
                throw new IOException("Failed to add local port forwarding entry for " + sshdSocketAddress + " -> " + sshdSocketAddress2);
            }
        }
        catch (IOException | Error | RuntimeException throwable) {
            try {
                this.localPortForwardingCancelled(sshdSocketAddress);
            }
            catch (IOException | Error | RuntimeException throwable2) {
                throwable.addSuppressed(throwable2);
            }
            this.signalEstablishedExplicitTunnel(sshdSocketAddress, null, true, null, throwable);
            throw throwable;
        }
        this.signalEstablishedExplicitTunnel(sshdSocketAddress, null, true, sshdSocketAddress2, null);
        return sshdSocketAddress2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress sshdSocketAddress) {
        LocalForwardingEntry localForwardingEntry;
        Object object = this.localForwards;
        synchronized (object) {
            localForwardingEntry = LocalForwardingEntry.findMatchingEntry(sshdSocketAddress.getHostName(), sshdSocketAddress.getPort(), this.localForwards);
            if (localForwardingEntry != null) {
                this.localForwards.remove(localForwardingEntry);
            }
        }
        if (localForwardingEntry != null && this.localAcceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled({}) unbind {}", (Object)sshdSocketAddress, (Object)localForwardingEntry);
            }
            object = localForwardingEntry.getCombinedBoundAddress();
            this.signalTearingDownExplicitTunnel((SshdSocketAddress)object, true, null);
            SshdSocketAddress sshdSocketAddress2 = localForwardingEntry.getBoundAddress();
            try {
                this.localAcceptor.unbind(sshdSocketAddress2.toInetSocketAddress());
            }
            catch (Error | RuntimeException throwable) {
                this.signalTornDownExplicitTunnel((SshdSocketAddress)object, true, null, throwable);
                throw throwable;
            }
            this.signalTornDownExplicitTunnel((SshdSocketAddress)object, true, null, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled({}) no match/acceptor: {}", (Object)sshdSocketAddress, (Object)localForwardingEntry);
        }
    }

    protected void signalEstablishingExplicitTunnel(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, boolean bl2) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalEstablishingExplicitTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, sshdSocketAddress2, bl2);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IOException("Failed (" + throwable.getClass().getSimpleName() + ") to signal establishing explicit tunnel for local=" + sshdSocketAddress + ", remote=" + sshdSocketAddress2 + ", localForwarding=" + bl2, throwable);
        }
    }

    protected void signalEstablishingExplicitTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, boolean bl2) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.establishingExplicitTunnel(this.getSession(), sshdSocketAddress, sshdSocketAddress2, bl2);
    }

    protected void signalEstablishedExplicitTunnel(SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, boolean bl2, SshdSocketAddress sshdSocketAddress3, Throwable throwable) {
        try {
            this.invokePortEventListenerSignaller(portForwardingEventListener -> {
                this.signalEstablishedExplicitTunnel((PortForwardingEventListener)portForwardingEventListener, sshdSocketAddress, sshdSocketAddress2, bl2, sshdSocketAddress3, throwable);
                return null;
            });
        }
        catch (IOException | Error | RuntimeException throwable2) {
            throw throwable2;
        }
        catch (Throwable throwable3) {
            throw new IOException("Failed (" + throwable3.getClass().getSimpleName() + ") to signal established explicit tunnel for local=" + sshdSocketAddress + ", remote=" + sshdSocketAddress2 + ", localForwarding=" + bl2 + ", bound=" + sshdSocketAddress3, throwable3);
        }
    }

    protected void signalEstablishedExplicitTunnel(PortForwardingEventListener portForwardingEventListener, SshdSocketAddress sshdSocketAddress, SshdSocketAddress sshdSocketAddress2, boolean bl2, SshdSocketAddress sshdSocketAddress3, Throwable throwable) {
        if (portForwardingEventListener == null) {
            return;
        }
        portForwardingEventListener.establishedExplicitTunnel(this.getSession(), sshdSocketAddress, sshdSocketAddress2, bl2, sshdSocketAddress3, throwable);
    }

    protected void invokePortEventListenerSignaller(Invoker invoker) {
        Throwable throwable;
        Throwable throwable2 = null;
        try {
            this.invokePortEventListenerSignallerListeners(this.getDefaultListeners(), invoker);
        }
        catch (Throwable throwable3) {
            throwable = ExceptionUtils.peelException(throwable3);
            throwable2 = ExceptionUtils.accumulateException(throwable2, throwable);
        }
        try {
            this.invokePortEventListenerSignallerHolders(this.managersHolder, invoker);
        }
        catch (Throwable throwable4) {
            throwable = ExceptionUtils.peelException(throwable4);
            throwable2 = ExceptionUtils.accumulateException(throwable2, throwable);
        }
        if (throwable2 != null) {
            throw throwable2;
        }
    }

    protected void invokePortEventListenerSignallerListeners(Collection collection, Invoker invoker) {
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        Throwable throwable = null;
        for (PortForwardingEventListener portForwardingEventListener : collection) {
            if (portForwardingEventListener == null) continue;
            try {
                invoker.invoke(portForwardingEventListener);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = ExceptionUtils.peelException(throwable2);
                throwable = ExceptionUtils.accumulateException(throwable, throwable3);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    protected void invokePortEventListenerSignallerHolders(Collection collection, Invoker invoker) {
        if (GenericUtils.isEmpty(collection)) {
            return;
        }
        Throwable throwable = null;
        for (PortForwardingEventListenerManager portForwardingEventListenerManager : collection) {
            Throwable throwable2;
            try {
                PortForwardingEventListener portForwardingEventListener = portForwardingEventListenerManager.getPortForwardingEventListenerProxy();
                if (portForwardingEventListener != null) {
                    invoker.invoke(portForwardingEventListener);
                }
            }
            catch (Throwable throwable3) {
                throwable2 = ExceptionUtils.peelException(throwable3);
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
            if (!(portForwardingEventListenerManager instanceof PortForwardingEventListenerManagerHolder)) continue;
            try {
                this.invokePortEventListenerSignallerHolders(((PortForwardingEventListenerManagerHolder)((Object)portForwardingEventListenerManager)).getRegisteredManagers(), invoker);
            }
            catch (Throwable throwable4) {
                throwable2 = ExceptionUtils.peelException(throwable4);
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    @Override
    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel(this.toString(), this.dynamicLocal.values()).close(this.localAcceptor).close(this.dynamicAcceptor).build();
    }

    @Override
    protected void preClose() {
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    protected IoAcceptor createIoAcceptor(Factory factory) {
        Session session = this.getSession();
        FactoryManager factoryManager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        IoServiceFactory ioServiceFactory = Objects.requireNonNull(factoryManager.getIoServiceFactory(), "No I/O service factory");
        IoHandler ioHandler = (IoHandler)factory.create();
        return ioServiceFactory.createAcceptor(ioHandler);
    }

    protected IoAcceptor getLocalIoAcceptor() {
        if (this.localAcceptor == null) {
            this.localAcceptor = this.createIoAcceptor(this.staticIoHandlerFactory);
        }
        return this.localAcceptor;
    }

    protected IoAcceptor getDynamicIoAcceptor() {
        if (this.dynamicAcceptor == null) {
            this.dynamicAcceptor = this.createIoAcceptor(this.socksProxyIoHandlerFactory);
        }
        return this.dynamicAcceptor;
    }

    protected InetSocketAddress doBind(SshdSocketAddress sshdSocketAddress, IoAcceptor ioAcceptor) {
        Set set = ioAcceptor.getBoundAddresses();
        try {
            InetSocketAddress inetSocketAddress = sshdSocketAddress.toInetSocketAddress();
            ioAcceptor.bind(inetSocketAddress);
            Set set2 = ioAcceptor.getBoundAddresses();
            if (GenericUtils.size(set2) > 0) {
                set2.removeAll(set);
            }
            if (GenericUtils.isEmpty(set2)) {
                throw new IOException("Error binding to " + sshdSocketAddress + "[" + inetSocketAddress + "]: no local addresses bound");
            }
            if (set2.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + sshdSocketAddress + "[" + inetSocketAddress + "]");
            }
            InetSocketAddress inetSocketAddress2 = (InetSocketAddress)GenericUtils.head(set2);
            return inetSocketAddress2;
        }
        catch (IOException iOException) {
            Set set3 = ioAcceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(set3)) {
                this.close();
            }
            throw iOException;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getBoundLocalPortForwards(int n2) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : this.localToRemote.keySet().stream().filter(sshdSocketAddress -> sshdSocketAddress.getPort() == n2).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocalPortForwardingStartedForPort(int n2) {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.keySet().stream().anyMatch(sshdSocketAddress -> sshdSocketAddress.getPort() == n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getLocalForwardsBindings() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : (List)this.localToRemote.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<SshdSocketAddress, SshdSocketAddress>((SshdSocketAddress)entry.getKey(), (SshdSocketAddress)entry.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.localToRemote.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getStartedLocalPortForwards() {
        Object object = this.localLock;
        synchronized (object) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : new ArrayList(this.localToRemote.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getRemoteForwardsBindings() {
        Map map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyList() : (List)this.remoteToLocal.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<Integer, SshdSocketAddress>((Integer)entry.getKey(), (SshdSocketAddress)entry.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.remoteToLocal.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshdSocketAddress getBoundRemotePortForward(int n2) {
        ValidateUtils.checkTrue(n2 > 0, "Invalid remote port: %d", n2);
        Integer n3 = n2;
        Map map = this.remoteToLocal;
        synchronized (map) {
            return (SshdSocketAddress)this.remoteToLocal.get(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet getStartedRemotePortForwards() {
        Map map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(this.remoteToLocal.keySet());
        }
    }

    static /* synthetic */ Object access$000(DefaultForwarder defaultForwarder) {
        return defaultForwarder.localLock;
    }

    static /* synthetic */ Map access$100(DefaultForwarder defaultForwarder) {
        return defaultForwarder.localToRemote;
    }

    static /* synthetic */ Set access$200(DefaultForwarder defaultForwarder) {
        return defaultForwarder.localForwards;
    }

    static /* synthetic */ Logger access$300(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$400(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$500(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$600(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$700(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ ConnectionService access$800(DefaultForwarder defaultForwarder) {
        return defaultForwarder.service;
    }

    static /* synthetic */ Logger access$900(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$1000(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$1100(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$1200(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$1300(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ void access$1400(DefaultForwarder defaultForwarder, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        defaultForwarder.warn(string, object, object2, object3, object4, object5, object6, throwable);
    }

    static /* synthetic */ Logger access$1500(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ Logger access$1600(DefaultForwarder defaultForwarder) {
        return defaultForwarder.log;
    }

    static /* synthetic */ void access$1700(DefaultForwarder defaultForwarder, String string, Object object, Object object2, Object object3, Throwable throwable) {
        defaultForwarder.warn(string, object, object2, object3, throwable);
    }
}

