/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.channel.StreamingChannel$Streaming;
import org.apache.sshd.common.forward.DefaultForwarder;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipClientChannel$Type;
import org.apache.sshd.common.forward.TcpipForwardingExceptionMarker;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.ThreadUtils;

class DefaultForwarder$StaticIoHandler
implements IoHandler {
    private final AtomicLong messagesCounter = new AtomicLong(0L);
    final /* synthetic */ DefaultForwarder this$0;

    DefaultForwarder$StaticIoHandler(DefaultForwarder defaultForwarder) {
        this.this$0 = defaultForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionCreated(IoSession ioSession) {
        SshdSocketAddress sshdSocketAddress;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ioSession.getLocalAddress();
        SshdSocketAddress sshdSocketAddress2 = new SshdSocketAddress(inetSocketAddress);
        Object object = DefaultForwarder.access$000(this.this$0);
        synchronized (object) {
            sshdSocketAddress = (SshdSocketAddress)SshdSocketAddress.findByOptionalWildcardAddress(DefaultForwarder.access$100(this.this$0), sshdSocketAddress2);
        }
        object = sshdSocketAddress == null ? TcpipClientChannel$Type.Forwarded : TcpipClientChannel$Type.Direct;
        TcpipClientChannel tcpipClientChannel = new TcpipClientChannel((TcpipClientChannel$Type)object, ioSession, sshdSocketAddress);
        tcpipClientChannel.setStreaming(StreamingChannel$Streaming.Async);
        ioSession.setAttribute(TcpipClientChannel.class, tcpipClientChannel);
        ioSession.suspendRead();
        if (object == TcpipClientChannel$Type.Forwarded) {
            SocketAddress socketAddress = ioSession.getAcceptanceAddress();
            LocalForwardingEntry localForwardingEntry = null;
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)socketAddress;
                InetAddress inetAddress = inetSocketAddress2.getAddress();
                Set set = DefaultForwarder.access$200(this.this$0);
                synchronized (set) {
                    localForwardingEntry = LocalForwardingEntry.findMatchingEntry(inetSocketAddress2.getHostString(), inetAddress.isAnyLocalAddress(), sshdSocketAddress2.getPort(), DefaultForwarder.access$200(this.this$0));
                }
            }
            if (localForwardingEntry != null) {
                if (DefaultForwarder.access$300(this.this$0).isDebugEnabled()) {
                    DefaultForwarder.access$400(this.this$0).debug("sessionCreated({})[local={}, remote={}, accepted={}] localEntry={}", new Object[]{ioSession, sshdSocketAddress2, sshdSocketAddress, socketAddress, localForwardingEntry});
                }
                tcpipClientChannel.updateLocalForwardingEntry(localForwardingEntry);
            } else {
                DefaultForwarder.access$500(this.this$0).warn("sessionCreated({})[local={}, remote={}] cannot locate original local entry for accepted={}", new Object[]{ioSession, sshdSocketAddress2, sshdSocketAddress, socketAddress});
            }
        } else if (DefaultForwarder.access$600(this.this$0).isDebugEnabled()) {
            DefaultForwarder.access$700(this.this$0).debug("sessionCreated({}) local={}, remote={}", new Object[]{ioSession, sshdSocketAddress2, sshdSocketAddress});
        }
        DefaultForwarder.access$800(this.this$0).registerChannel(tcpipClientChannel);
        tcpipClientChannel.open().addListener(openFuture -> {
            ioSession.resumeRead();
            Throwable throwable = openFuture.getException();
            if (throwable != null) {
                DefaultForwarder.access$1700(this.this$0, "Failed ({}) to open channel for session={}: {}", throwable.getClass().getSimpleName(), ioSession, throwable.getMessage(), throwable);
                DefaultForwarder.access$800(this.this$0).unregisterChannel(tcpipClientChannel);
                tcpipClientChannel.close(false);
            }
        });
    }

    @Override
    public void sessionClosed(IoSession ioSession) {
        TcpipClientChannel tcpipClientChannel = (TcpipClientChannel)ioSession.removeAttribute(TcpipClientChannel.class);
        Throwable throwable = (Throwable)ioSession.removeAttribute(TcpipForwardingExceptionMarker.class);
        if (DefaultForwarder.access$900(this.this$0).isDebugEnabled()) {
            DefaultForwarder.access$1000(this.this$0).debug("sessionClosed({}) closing channel={} after {} messages - cause={}", new Object[]{ioSession, tcpipClientChannel, this.messagesCounter, throwable == null ? null : throwable.getClass().getSimpleName()});
        }
        if (tcpipClientChannel == null) {
            return;
        }
        tcpipClientChannel.close(throwable != null);
    }

    @Override
    public void messageReceived(IoSession ioSession, Readable readable) {
        TcpipClientChannel tcpipClientChannel = (TcpipClientChannel)ioSession.getAttribute(TcpipClientChannel.class);
        long l2 = this.messagesCounter.incrementAndGet();
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(readable.available(), false);
        byteArrayBuffer.putBuffer(readable);
        if (DefaultForwarder.access$1100(this.this$0).isTraceEnabled()) {
            DefaultForwarder.access$1200(this.this$0).trace("messageReceived({}) channel={}, count={}, handle len={}", new Object[]{ioSession, tcpipClientChannel, l2, readable.available()});
        }
        ioSession.suspendRead();
        ThreadUtils.runAsInternal(() -> (IoWriteFuture)tcpipClientChannel.getAsyncIn().writeBuffer(byteArrayBuffer).addListener(ioWriteFuture -> {
            ioSession.resumeRead();
            Throwable throwable = ioWriteFuture.getException();
            if (throwable != null) {
                try {
                    this.exceptionCaught(ioSession, throwable);
                }
                catch (Exception exception) {
                    DefaultForwarder.access$1400(this.this$0, "messageReceived({}) failed ({}) to signal {}[{}] on channel={}: {}", ioSession, exception.getClass().getSimpleName(), throwable.getClass().getSimpleName(), throwable.getMessage(), tcpipClientChannel, exception.getMessage(), exception);
                }
            } else if (DefaultForwarder.access$1500(this.this$0).isTraceEnabled()) {
                DefaultForwarder.access$1600(this.this$0).trace("messageReceived({}) channel={} message={} forwarded", new Object[]{ioSession, tcpipClientChannel, l2});
            }
        }));
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) {
        ioSession.setAttribute(TcpipForwardingExceptionMarker.class, throwable);
        DefaultForwarder.access$1300(this.this$0).warn("exceptionCaught({}) {}: {}", new Object[]{ioSession, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable});
        ioSession.close(true);
    }
}

