/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class ChannelToPortHandler
extends AbstractLoggingBean {
    private final IoSession port;
    private final Channel channel;

    public ChannelToPortHandler(IoSession ioSession, Channel channel) {
        this.port = Objects.requireNonNull(ioSession, "No port IoSession");
        this.channel = Objects.requireNonNull(channel, "No Channel");
    }

    public IoSession getPortSession() {
        return this.port;
    }

    public void handleEof() {
        this.port.shutdownOutputStream();
    }

    public void sendToPort(byte by, byte[] byArray, int n2, long l2) {
        ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", l2);
        ByteArrayBuffer byteArrayBuffer = ByteArrayBuffer.getCompactClone(byArray, n2, (int)l2);
        this.port.writeBuffer(byteArrayBuffer).addListener(ioWriteFuture -> {
            if (ioWriteFuture.isWritten()) {
                this.handleWriteDataSuccess(by, byteArrayBuffer.array(), 0, (int)l2);
            } else {
                this.handleWriteDataFailure(by, byteArrayBuffer.array(), 0, (int)l2, ioWriteFuture.getException());
            }
        });
    }

    protected void handleWriteDataSuccess(byte by, byte[] byArray, int n2, int n3) {
        this.checkWindow(by, n3);
    }

    protected void handleWriteDataFailure(byte by, byte[] byArray, int n2, int n3, Throwable throwable) {
        this.debug("handleWriteDataFailure({}, {})[{}] failed ({}) to write len={}: {}", this.channel, this.port, SshConstants.getCommandMessageName(by & 0xFF), throwable.getClass().getSimpleName(), n3, throwable.getMessage(), throwable);
        if (this.port.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] closing session={}", new Object[]{this.channel, SshConstants.getCommandMessageName(by & 0xFF), this.port});
            }
            this.checkWindow(by, n3);
            this.channel.close(false);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataFailure({})[{}] ignoring writeDataFailure {} because ioSession {} is already closing ", new Object[]{this.channel, SshConstants.getCommandMessageName(by & 0xFF), throwable, this.port});
            }
            this.checkWindow(by, n3);
        }
    }

    private void checkWindow(byte by, long l2) {
        try {
            LocalWindow localWindow = this.channel.getLocalWindow();
            if (localWindow.isOpen()) {
                localWindow.release(l2);
            }
        }
        catch (Throwable throwable) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to check local window: {}", new Object[]{this.channel, SshConstants.getCommandMessageName(by & 0xFF), throwable.getClass().getSimpleName(), throwable.getMessage()});
            }
            this.channel.getSession().exceptionCaught(throwable);
        }
    }
}

