/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.virtualfs;

import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.root.RootedFileSystemProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;

public class VirtualFileSystemFactory
implements FileSystemFactory {
    private Path defaultHomeDir;
    private final Map homeDirs = new ConcurrentHashMap();

    public VirtualFileSystemFactory() {
    }

    public VirtualFileSystemFactory(Path path) {
        this.defaultHomeDir = path;
    }

    public void setDefaultHomeDir(Path path) {
        this.defaultHomeDir = path;
    }

    public Path getDefaultHomeDir() {
        return this.defaultHomeDir;
    }

    public void setUserHomeDir(String string, Path path) {
        this.homeDirs.put(ValidateUtils.checkNotNullAndNotEmpty(string, "No username"), Objects.requireNonNull(path, "No home dir"));
    }

    public Path getUserHomeDir(String string) {
        return (Path)this.homeDirs.get(ValidateUtils.checkNotNullAndNotEmpty(string, "No username"));
    }

    @Override
    public Path getUserHomeDir(SessionContext sessionContext) {
        String string = sessionContext.getUsername();
        Path path = this.getUserHomeDir(string);
        if (path == null) {
            path = this.getDefaultHomeDir();
        }
        return path;
    }

    @Override
    public FileSystem createFileSystem(SessionContext sessionContext) {
        Path path = this.getUserHomeDir(sessionContext);
        if (path == null) {
            throw new InvalidPathException(sessionContext.getUsername(), "Cannot resolve home directory");
        }
        return new RootedFileSystemProvider().newFileSystem(path, Collections.emptyMap());
    }
}

