/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.file.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.common.file.util.MockFileSystem;

public class MockPath
implements Path {
    private final String path;
    private final FileSystem fs;

    public MockPath(String string) {
        this.path = string;
        this.fs = new MockFileSystem(string);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public Path getRoot() {
        return this;
    }

    @Override
    public Path getFileName() {
        return this;
    }

    @Override
    public Path getParent() {
        return null;
    }

    @Override
    public int getNameCount() {
        return 0;
    }

    @Override
    public Path getName(int n2) {
        if (n2 == 0) {
            return this;
        }
        throw new IllegalArgumentException("getName - bad index: " + n2);
    }

    @Override
    public Path subpath(int n2, int n3) {
        throw new UnsupportedOperationException("subPath(" + n2 + "," + n3 + ") N/A");
    }

    @Override
    public boolean startsWith(Path path) {
        return this.startsWith(path.toString());
    }

    @Override
    public boolean startsWith(String string) {
        return this.path.startsWith(string);
    }

    @Override
    public boolean endsWith(Path path) {
        return this.endsWith(path.toString());
    }

    @Override
    public boolean endsWith(String string) {
        return this.path.endsWith(string);
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path path) {
        return this.resolve(path.toString());
    }

    @Override
    public Path resolve(String string) {
        throw new UnsupportedOperationException("resolve(" + string + ") N/A");
    }

    @Override
    public Path resolveSibling(Path path) {
        return this.resolveSibling(path.toString());
    }

    @Override
    public Path resolveSibling(String string) {
        throw new UnsupportedOperationException("resolveSibling(" + string + ") N/A");
    }

    @Override
    public Path relativize(Path path) {
        throw new UnsupportedOperationException("relativize(" + path + ") N/A");
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException("toUri() N/A");
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptionArray) {
        return this;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("toFile() N/A");
    }

    public WatchKey register(WatchService watchService, WatchEvent.Kind ... kindArray) {
        return this.register(watchService, kindArray, (WatchEvent.Modifier[])null);
    }

    public WatchKey register(WatchService watchService, WatchEvent.Kind[] kindArray, WatchEvent.Modifier ... modifierArray) {
        throw new IOException("register(" + this.path + ") N/A");
    }

    @Override
    public Iterator iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public int compareTo(Path path) {
        return this.path.compareTo(path.toString());
    }

    @Override
    public String toString() {
        return this.path;
    }
}

